/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client;

import com.alekiponi.alekiships.common.entity.CannonEntity;
import com.alekiponi.alekiships.common.entity.IHaveIcons;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopUnderConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public enum IngameOverlays {
    COMPARTMENT_STATUS(IngameOverlays::renderEntityIcons),
    PASSENGER_STATUS(IngameOverlays::renderPassengerStatus),
    SAILING_ELEMENT(IngameOverlays::renderSailingElement),
    SLOOP_CONSTRUCTION(IngameOverlays::renderSloopConstructionStatus),
    CANNON_LOAD_STATE(IngameOverlays::renderCannonLoadState);

    public static final ResourceLocation COMPARTMENT_ICONS;
    public static final ResourceLocation SAILING_ICONS;
    public static final ResourceLocation SPEEDOMETER_ICONS;
    public static final Component PRESS_BUTTON;
    public static final Component EJECT_PASSENGERS;
    private static final ItemStack FLINT_AND_STEEL;
    public static final int MAGIC_STRING_COLOR = 0xFFFFFF;
    private final IGuiOverlay overlay;
    private final String id = this.name().toLowerCase(Locale.ROOT);

    private IngameOverlays(IGuiOverlay overlay) {
        this.overlay = overlay;
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        IngameOverlays.above(event, VanillaGuiOverlay.CROSSHAIR, COMPARTMENT_STATUS);
        IngameOverlays.above(event, VanillaGuiOverlay.CROSSHAIR, PASSENGER_STATUS);
        IngameOverlays.above(event, VanillaGuiOverlay.CROSSHAIR, SLOOP_CONSTRUCTION);
        IngameOverlays.above(event, VanillaGuiOverlay.CROSSHAIR, CANNON_LOAD_STATE);
        IngameOverlays.above(event, VanillaGuiOverlay.HOTBAR, SAILING_ELEMENT);
    }

    private static void above(RegisterGuiOverlaysEvent event, VanillaGuiOverlay vanilla, IngameOverlays overlay) {
        event.registerAbove(vanilla.id(), overlay.id, overlay.overlay);
    }

    private static void renderPassengerStatus(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        EmptyCompartmentEntity compartment;
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!IngameOverlays.setup(gui, mc) || mc.f_91074_.m_5833_() || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        Entity entity = CommonHelper.getEntity(mc.f_91077_);
        if (entity == null) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        if (!(entity.m_20202_() instanceof EmptyCompartmentEntity || entity instanceof EmptyCompartmentEntity && (compartment = (EmptyCompartmentEntity)entity).m_146862_(e -> true))) {
            return;
        }
        if (!(entity instanceof EmptyCompartmentEntity) && !(entity instanceof LivingEntity) || entity instanceof ArmorStand) {
            return;
        }
        if (entity instanceof EmptyCompartmentEntity && (compartment = (EmptyCompartmentEntity)entity).m_146895_() instanceof ArmorStand) {
            return;
        }
        stack.m_85836_();
        stack.m_252880_((float)width / 2.0f, (float)height / 2.0f - 15.0f, 0.0f);
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        String string = PRESS_BUTTON.getString() + " " + mc.f_91066_.f_92090_.m_90863_().getString() + " + " + mc.f_91066_.f_92095_.m_90863_().getString() + " " + EJECT_PASSENGERS.getString();
        graphics.m_280056_(mc.f_91062_, string, -mc.f_91062_.m_92895_(string) / 2, 0, Color.WHITE.getRGB(), true);
        stack.m_85849_();
    }

    private static void renderSloopConstructionStatus(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        ConstructionEntity constructionEntity;
        Entity entity;
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!IngameOverlays.setup(gui, mc) || mc.f_91074_.m_5833_() || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        Entity entity2 = CommonHelper.getEntity(mc.f_91077_);
        if (!(entity2 instanceof ConstructionEntity) || !((entity = (constructionEntity = (ConstructionEntity)entity2).m_20201_()) instanceof SloopUnderConstructionEntity)) {
            return;
        }
        SloopUnderConstructionEntity sloop = (SloopUnderConstructionEntity)entity;
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_((float)width / 2.0f, (float)height / 2.0f - 15.0f, 0.0f);
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        ItemStack itemStack = new ItemStack((ItemLike)sloop.getCurrentRequiredItem(), sloop.getNumberItemsLeft());
        graphics.m_280203_(itemStack, 0, 0);
        if (itemStack.m_41613_() != 1) {
            stack.m_85836_();
            String countString = String.valueOf(itemStack.m_41613_());
            stack.m_252880_(0.0f, 0.0f, 200.0f);
            graphics.m_280056_(mc.f_91062_, countString, 17 - mc.f_91062_.m_92895_(countString), 9, 0xFFFFFF, true);
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    private static void renderCannonLoadState(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!IngameOverlays.setup(gui, mc) || mc.f_91074_.m_5833_() || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        Entity entity = CommonHelper.getEntity(mc.f_91077_);
        if (!(entity instanceof CannonEntity)) {
            return;
        }
        CannonEntity cannon = (CannonEntity)entity;
        if (cannon.isLit()) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_((float)width / 2.0f, (float)height / 2.0f - 15.0f, 0.0f);
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        if (cannon.isLoaded()) {
            graphics.m_280203_(FLINT_AND_STEEL, 0, 0);
        } else {
            graphics.m_280203_(cannon.nextRequiredItem(), 0, 0);
        }
        stack.m_85849_();
    }

    private static void renderSailingElement(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        int deferredAngle;
        int offhandOffset;
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!IngameOverlays.setup(gui, mc) || mc.f_91074_.m_5833_()) {
            return;
        }
        Entity entity = mc.f_91074_.m_20201_();
        if (!(entity instanceof SloopEntity)) {
            return;
        }
        SloopEntity sloopEntity = (SloopEntity)entity;
        if (sloopEntity.getPilotCompartment() == null) {
            return;
        }
        if (!sloopEntity.getPilotCompartment().m_146898_()) {
            return;
        }
        if (sloopEntity.getPilotCompartment().m_146895_() != mc.f_91074_) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        int x = width / 2;
        int y = height - gui.rightHeight;
        stack.m_252880_((float)(x + 1), (float)(y + 4), 0.0f);
        if (height % 2 != 0) {
            stack.m_252880_(0.0f, 0.5f, 0.0f);
        }
        if (width % 2 != 0) {
            stack.m_252880_(0.5f, 0.0f, 0.0f);
        }
        double smoothSpeedMS = sloopEntity.getSmoothSpeedMS();
        String displayBoatSpeed = new DecimalFormat("###.#").format(smoothSpeedMS * 3.6) + " km/h";
        int windSpeed = Mth.m_14045_((int)((int)(sloopEntity.getLocalWindAngleAndSpeed()[1] * 160.0f)), (int)1, (int)20);
        int ticksBetweenFrames = Mth.m_14045_((int)Math.abs(windSpeed - 20), (int)1, (int)20);
        int ticks = sloopEntity.f_19797_ / ticksBetweenFrames;
        int frameIndex = ticks % 32;
        int n = offhandOffset = !mc.f_91074_.m_21206_().m_41619_() ? 26 : 3;
        if (mc.f_91066_.f_92063_) {
            graphics.m_280056_(mc.f_91062_, displayBoatSpeed, -134, -8 - offhandOffset, Color.WHITE.getRGB(), true);
        }
        if ((deferredAngle = Math.round(Mth.m_14177_((float)sloopEntity.getWindLocalRotation()) / 360.0f * 64.0f) + 32) == 64) {
            deferredAngle = 0;
        }
        int angle = deferredAngle;
        int speedometerIndex = Mth.m_14045_((int)((int)(smoothSpeedMS - 2.0) * 2), (int)0, (int)31);
        graphics.m_280218_(SAILING_ICONS, -126, 3 - offhandOffset, 32 * angle, 32 * (angle / 8), 32, 32);
        graphics.m_280218_(SPEEDOMETER_ICONS, -134, 3 - offhandOffset + 32 - 16, 16 * speedometerIndex, 16 * (speedometerIndex / 16), 16, 16);
        graphics.m_280218_(SPEEDOMETER_ICONS, -134, 3 - offhandOffset, 16 * frameIndex, 32 + 16 * (frameIndex / 16), 16, 16);
        stack.m_85849_();
    }

    private static void renderEntityIcons(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (!IngameOverlays.setup(gui, mc) || player.m_5833_() || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        Entity entity = CommonHelper.getEntity(mc.f_91077_);
        if (entity instanceof IHaveIcons) {
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            stack.m_85841_(1.0f, 1.0f, 1.0f);
            stack.m_252880_((float)width / 2.0f - 5.0f - 12.0f, (float)height / 2.0f - 5.0f, 0.0f);
            if (height % 2 != 0) {
                stack.m_252880_(0.0f, 0.5f, 0.0f);
            }
            if (width % 2 != 0) {
                stack.m_252880_(0.5f, 0.0f, 0.0f);
            }
            ArrayList<IconState> states = ((IHaveIcons)entity).getIconStates((Player)player);
            block15: for (int i = 0; i < states.size(); ++i) {
                IconState state = states.get(i);
                int offset = -12 * i;
                switch (state) {
                    case NONE: {
                        continue block15;
                    }
                    case HELM: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.HELM), 0, 9, 9);
                        continue block15;
                    }
                    case BLOCK: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.BLOCK), 0, 9, 9);
                        continue block15;
                    }
                    case SAIL_ARROW_UP: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.SAIL), 0, 9, 9);
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, -10, Icon.offset(Icon.ARROW_UP), 0, 9, 9);
                        continue block15;
                    }
                    case SAIL_ARROW_DOWN: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.SAIL), 0, 9, 9);
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 10, Icon.offset(Icon.ARROW_DOWN), 0, 9, 9);
                        continue block15;
                    }
                    case PADDLE: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.PADDLE), 0, 9, 9);
                        continue block15;
                    }
                    case SEAT: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.SEAT), 0, 9, 9);
                        continue block15;
                    }
                    case EJECT: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.EJECT), 0, 9, 9);
                        continue block15;
                    }
                    case LEAD: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.LEAD), 0, 9, 9);
                        continue block15;
                    }
                    case ANCHOR_ARROW_UP: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.ANCHOR), 0, 9, 9);
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, -10, Icon.offset(Icon.ARROW_UP), 0, 9, 9);
                        continue block15;
                    }
                    case ANCHOR_ARROW_DOWN: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.ANCHOR), 0, 9, 9);
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 10, Icon.offset(Icon.ARROW_DOWN), 0, 9, 9);
                        continue block15;
                    }
                    case BRUSH: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.BRUSH), 0, 9, 9);
                        continue block15;
                    }
                    case HAMMER: {
                        graphics.m_280218_(COMPARTMENT_ICONS, offset, 0, Icon.offset(Icon.HAMMER), 0, 9, 9);
                    }
                }
            }
            stack.m_85849_();
        }
    }

    public static boolean setup(ForgeGui gui, Minecraft minecraft) {
        if (!minecraft.f_91066_.f_92062_ && minecraft.m_91288_() instanceof Player) {
            gui.setupOverlayRenderState(true, false);
            return true;
        }
        return false;
    }

    static {
        COMPARTMENT_ICONS = new ResourceLocation("alekiships", "textures/gui/icons/compartment_icons.png");
        SAILING_ICONS = new ResourceLocation("alekiships", "textures/gui/icons/sailing_icons.png");
        SPEEDOMETER_ICONS = new ResourceLocation("alekiships", "textures/gui/icons/speedometer_icons.png");
        PRESS_BUTTON = Component.m_237115_((String)"press_button");
        EJECT_PASSENGERS = Component.m_237115_((String)"eject_passengers");
        FLINT_AND_STEEL = new ItemStack((ItemLike)Items.f_42409_);
    }

    public static enum IconState {
        NONE,
        HELM,
        BLOCK,
        SAIL_ARROW_UP,
        SAIL_ARROW_DOWN,
        PADDLE,
        SEAT,
        EJECT,
        LEAD,
        ANCHOR_ARROW_UP,
        ANCHOR_ARROW_DOWN,
        BRUSH,
        HAMMER;

    }

    public static enum Icon {
        HELM(0),
        BLOCK(1),
        SAIL(2),
        PADDLE(3),
        SEAT(4),
        EJECT(5),
        LEAD(6),
        ARROW_UP(7),
        ARROW_DOWN(8),
        ANCHOR(9),
        BRUSH(10),
        HAMMER(11);

        public final int index;

        private Icon(int index) {
            this.index = index;
        }

        public static int offset(Icon icon) {
            return icon.index * 9;
        }
    }
}

