/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehicle;

import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IAmTiny;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveAnchorWindlass;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveCleats;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IPaintable;
import com.alekiponi.alekiships.network.AlekiShipsEntityDataSerializers;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.ClientHelper;
import com.alekiponi.alekiships.wind.Wind;
import com.alekiponi.alekiships.wind.WindModel;
import com.alekiponi.alekiships.wind.WindModels;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public abstract class AbstractAlekiBoatEntity
extends AbstractVehicle {
    public static final int PADDLE_LEFT = 0;
    public static final int PADDLE_RIGHT = 1;
    public static final double PADDLE_SOUND_TIME = 0.7853981633974483;
    protected static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(AbstractAlekiBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(AbstractAlekiBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Wind> DATA_ID_WIND_VECTOR = SynchedEntityData.m_135353_(AbstractAlekiBoatEntity.class, (EntityDataSerializer)((EntityDataSerializer)AlekiShipsEntityDataSerializers.WIND.get()));
    protected static final EntityDataAccessor<Boolean> DATA_ID_IMMOBILE = SynchedEntityData.m_135353_(AbstractAlekiBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int WIND_UPDATE_TICKS = 40;
    protected final float[] paddlePositions = new float[2];
    protected Wind oldWind = Wind.ZERO;
    protected int windLerpTicks = 0;
    protected WindModel windModel;
    protected final BoatMaterial boatMaterial;

    public AbstractAlekiBoatEntity(EntityType<? extends AbstractAlekiBoatEntity> entityType, Level level, BoatMaterial boatMaterial) {
        super(entityType, level);
        this.windModel = WindModels.get(level);
        this.boatMaterial = boatMaterial;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_WIND_VECTOR, (Object)Wind.ZERO);
        this.f_19804_.m_135372_(DATA_ID_IMMOBILE, (Object)false);
    }

    @Override
    public float renderSizeForCompartments() {
        return 0.6875f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.oldStatus = this.status;
        this.status = this.getStatus();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (!this.isFunctional()) {
            if (this.status == AbstractVehicle.MediumStatus.IN_WATER) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
            }
            for (Entity entity : this.m_20197_()) {
                entity.m_19877_();
                entity.m_6074_();
            }
            if (this.getDamage() > this.getDeathDamageThreshold()) {
                this.m_6074_();
            }
        }
        if (this.status == AbstractVehicle.MediumStatus.UNDER_WATER && this.isFunctional() && this.f_19797_ % 20 == 0) {
            this.m_6469_(this.m_269291_().m_269063_(), this.getDamageRecovery());
        }
        if (this.everyNthTickUnique(5) && this.m_9236_().m_8055_(this.m_20183_()).m_60713_(Blocks.f_50126_) && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60713_(Blocks.f_50016_)) {
            this.m_146884_(this.m_20318_(0.0f).m_82520_(0.0, 1.0, 0.0));
        }
        this.tickEffects();
        this.tickLerp();
        this.tickWindInput();
        if (this instanceof IHaveCleats) {
            ((IHaveCleats)((Object)this)).tickCleatInput();
        }
        if (this instanceof IHaveAnchorWindlass) {
            ((IHaveAnchorWindlass)((Object)this)).tickAnchorInput();
        }
        this.tickFloatBoat();
        this.tickControlBoat();
        if (this.m_6109_() && this.m_9236_().m_5776_()) {
            this.m_9236_().m_5503_((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
        }
        if (this.everyNthTickUnique(4)) {
            Player player = this.m_9236_().m_45930_((Entity)this, 144.0);
            if (player != null) {
                if (this.m_20270_((Entity)player) < 128.0f) {
                    this.setImmobile(false);
                }
            } else {
                this.setImmobile(true);
            }
        }
        if (!this.getImmobile()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.tickPaddlingEffects();
        this.tickUpdateWind(true);
        this.m_146922_(this.m_146908_() + this.getDeltaRotation());
        if (this.m_9236_().m_5776_()) {
            ClientHelper.tickHopPlayersOnboard(this);
        }
        this.tickTakeEntitiesForARide();
    }

    @Override
    public float getDeathDamageThreshold() {
        return this.getDamageThreshold() * 1.25f;
    }

    protected void tickWindInput() {
        if (this.status == AbstractVehicle.MediumStatus.IN_WATER || this.status == AbstractVehicle.MediumStatus.IN_AIR) {
            double windFunction = Mth.m_14008_((double)this.getLocalWindAngleAndSpeed()[1], (double)0.001, (double)(0.002 * this.m_20191_().m_82362_())) * this.windDriftMultiplier();
            float windDifference = Mth.m_14118_((float)this.getLocalWindAngleAndSpeed()[0], (float)Mth.m_14177_((float)this.m_146908_()));
            if (Math.abs(windDifference) < 90.0f) {
                float angleMultiplier = Math.abs((Math.abs(windDifference) - 90.0f) / 90.0f);
                this.m_20256_(this.m_20184_().m_82520_((double)Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * windFunction * 0.45 * (double)angleMultiplier, 0.0, (double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * windFunction * 0.45 * (double)angleMultiplier));
            }
            this.m_20256_(this.m_20184_().m_82520_((double)Mth.m_14031_((float)(-this.getLocalWindAngleAndSpeed()[0] * ((float)Math.PI / 180))) * windFunction * 0.55, 0.0, (double)Mth.m_14089_((float)(this.getLocalWindAngleAndSpeed()[0] * ((float)Math.PI / 180))) * windFunction * 0.55));
            if (this.status == AbstractVehicle.MediumStatus.IN_WATER) {
                if (windDifference > 1.0f) {
                    this.setDeltaRotation(this.getDeltaRotation() - 0.1f);
                } else if (windDifference < -1.0f) {
                    this.setDeltaRotation(this.getDeltaRotation() + 0.1f);
                }
            }
        }
    }

    protected abstract double windDriftMultiplier();

    protected void tickUpdateWind(boolean waitForWindUpdateTick) {
        if (this.everyNthTickUnique(40) || !waitForWindUpdateTick) {
            Wind wind = this.windModel.getWind(this.m_20183_());
            if (wind.speed == 0.0f) {
                wind = new Wind(-0.03f, 0.0f);
            }
            this.setWind(wind);
            this.updateLocalWindAngleAndSpeed();
        }
        if (this.windLerpTicks > 0 && this.m_9236_().m_5776_()) {
            this.updateLocalWindAngleAndSpeed();
        }
    }

    protected void tickFloatBoat() {
        double gravityAccel = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == AbstractVehicle.MediumStatus.IN_AIR && this.status != AbstractVehicle.MediumStatus.IN_AIR && this.status != AbstractVehicle.MediumStatus.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = AbstractVehicle.MediumStatus.IN_WATER;
        } else {
            if (this.status == AbstractVehicle.MediumStatus.IN_WATER || this.status == AbstractVehicle.MediumStatus.UNDER_FLOWING_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_() + 0.1;
                this.invFriction = 0.9f;
            } else if (this.status == AbstractVehicle.MediumStatus.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == AbstractVehicle.MediumStatus.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == AbstractVehicle.MediumStatus.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.invFriction > 0.5f) {
                    this.invFriction = 0.5f;
                }
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            if (Math.abs(this.getDeltaRotation()) > 0.0f) {
                float rotationalFriction = Math.abs(this.getDeltaRotation()) / 48.0f;
                float modifiedFriction = this.invFriction - rotationalFriction;
                if (modifiedFriction > 2.0f) {
                    modifiedFriction = 2.0f;
                } else if (modifiedFriction < 0.0f) {
                    modifiedFriction = 0.0f;
                }
                this.invFriction = modifiedFriction;
            }
            this.tickTurnSpeedFactor();
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.invFriction, vec3.f_82480_ + gravityAccel, vec3.f_82481_ * (double)this.invFriction);
            if (d2 > 0.0) {
                Vec3 movement = this.m_20184_();
                this.m_20334_(movement.f_82479_, (movement.f_82480_ + d2 * 0.06153846016296973) * 0.75, movement.f_82481_);
            }
            if (this.status == AbstractVehicle.MediumStatus.UNDER_WATER && this.m_9236_().m_6425_(this.m_20183_().m_6630_(3)).m_76178_() && this.isFunctional()) {
                this.m_20334_(this.m_20184_().f_82479_, 0.05, this.m_20184_().f_82481_);
            }
        }
    }

    protected void tickTurnSpeedFactor() {
        if (this.getPilotCompartment() != null) {
            double turnSpeedFactor = this.m_20184_().m_82553_() * 12.0;
            if (this.getPilotCompartment().getInputLeft() || this.getPilotCompartment().getInputRight()) {
                this.setDeltaRotation(this.invFriction / 3.0f * this.getDeltaRotation());
                this.setDeltaRotation((float)(turnSpeedFactor * (double)this.getDeltaRotation()));
            } else {
                this.setDeltaRotation(this.getDeltaRotation() * (this.invFriction / 2.0f));
            }
        }
    }

    protected void tickControlBoat() {
        if (this.getPilotCompartment() != null) {
            boolean inputUp = this.getPilotCompartment().getInputUp();
            boolean inputDown = this.getPilotCompartment().getInputDown();
            boolean inputLeft = this.getPilotCompartment().getInputLeft();
            boolean inputRight = this.getPilotCompartment().getInputRight();
            float acceleration = 0.0f;
            float paddleMultiplier = this.getPaddleMultiplier();
            float forward = this.getPaddleAcceleration()[0];
            float backward = this.getPaddleAcceleration()[1];
            float turning = this.getPaddleAcceleration()[2];
            if (inputLeft) {
                this.setDeltaRotation(this.getDeltaRotation() - this.getTurnSpeed());
            }
            if (inputRight) {
                this.setDeltaRotation(this.getDeltaRotation() + this.getTurnSpeed());
            }
            if (inputRight != inputLeft && !inputUp && !inputDown) {
                acceleration += turning * paddleMultiplier;
            }
            if (inputUp) {
                acceleration += forward * paddleMultiplier;
            }
            if (inputDown) {
                acceleration -= backward * paddleMultiplier;
            }
            if (Math.abs(acceleration) > Math.abs(this.getAcceleration())) {
                this.setAcceleration(acceleration);
            } else {
                if (Math.abs(this.getAcceleration()) < 1.0f) {
                    this.setAcceleration(0.0f);
                } else if (this.getAcceleration() > 0.0f) {
                    this.setAcceleration(this.getAcceleration() - this.getMomentumSubtractor());
                } else if (this.getAcceleration() < 0.0f) {
                    this.setAcceleration(this.getAcceleration() + this.getMomentumSubtractor());
                }
                acceleration = this.getAcceleration();
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * acceleration), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * acceleration)));
            this.setPaddleState(inputRight && !inputLeft || inputUp, inputLeft && !inputRight || inputUp);
        }
    }

    protected abstract float getPaddleMultiplier();

    protected float[] getPaddleAcceleration() {
        float forward = 0.055f;
        float backward = 0.025f;
        float turning = 0.005f;
        return new float[]{forward, backward, turning};
    }

    protected float getTurnSpeed() {
        return 1.0f;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(this.getDropItem())) {
            if (player.m_150110_().f_35937_) {
                this.setDamage(0.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.getDamage() > 0.0f) {
                this.setDamage(this.getDamage() - this.getDamageRecovery());
                stack.m_41620_(1);
                player.m_6674_(hand);
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.5f, this.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_5825_() {
        return this.boatMaterial.withstandsLava();
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        if (this instanceof IAmTiny) {
            return states;
        }
        for (ItemStack itemStack : player.m_6167_()) {
            IPaintable paintable;
            AbstractAlekiBoatEntity abstractAlekiBoatEntity;
            if (itemStack.m_41619_()) {
                return states;
            }
            if (itemStack.m_150930_(this.getDropItem()) && this.getDamage() > 0.0f) {
                states.add(IngameOverlays.IconState.HAMMER);
                return states;
            }
            if (!itemStack.m_204117_(Tags.Items.DYES) && !itemStack.m_150930_(Items.f_42447_) || !((abstractAlekiBoatEntity = this) instanceof IPaintable) || !(paintable = (IPaintable)((Object)abstractAlekiBoatEntity)).getPaintColor().isEmpty() && paintable.getPaintColor().get() == ((DyeItem)itemStack.m_41720_()).m_41089_()) continue;
            states.add(IngameOverlays.IconState.BRUSH);
            return states;
        }
        return states;
    }

    protected abstract float getMomentumSubtractor();

    protected void tickEffects() {
        if (this.status == AbstractVehicle.MediumStatus.IN_WATER && !this.m_20197_().isEmpty()) {
            if (Math.abs(this.getDeltaRotation()) > 2.0f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5501_(), this.m_5720_(), 0.2f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
                }
                if (this.getPilotCompartment() != null && Math.abs(this.getDeltaRotation()) > 5.0f && (this.getPilotCompartment().getInputRight() || this.getPilotCompartment().getInputLeft())) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5508_(), this.m_5720_(), 0.2f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
                    Vec3 splashOffset = this.m_20184_().m_82524_(45.0f);
                    if (this.getPilotCompartment().getInputLeft()) {
                        splashOffset = this.m_20184_().m_82524_(-45.0f);
                    }
                    splashOffset.m_82541_();
                    for (int i = 0; i < 8; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.m_20185_() + (double)this.f_19796_.m_188501_() + splashOffset.f_82479_ * 2.0 + this.m_20184_().f_82479_ * (double)i, this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_() + splashOffset.f_82481_ * 2.0 + this.m_20184_().f_82479_ * (double)i, 0.0, 0.0, 0.0);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_() + splashOffset.f_82479_ * 2.0 + this.m_20184_().f_82479_ * (double)i, this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_() + splashOffset.f_82481_ * 2.0 + this.m_20184_().f_82479_ * (double)i, 0.0, 0.0, 0.0);
                    }
                }
            } else if (this.m_20184_().m_82553_() > 0.1 && this.f_19796_.m_188503_(8) == 0) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5501_(), this.m_5720_(), 0.1f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void tickPaddlingEffects() {
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.m_20067_() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.paddlePositions[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vec3 = this.m_20252_(1.0f);
                    double d0 = i == 1 ? -vec3.f_82481_ : vec3.f_82481_;
                    double d1 = i == 1 ? vec3.f_82479_ : -vec3.f_82479_;
                    this.m_9236_().m_6263_(null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                    this.m_9236_().m_142346_((Entity)this.m_6688_(), GameEvent.f_157784_, new BlockPos((int)(this.m_20185_() + d0), (int)this.m_20186_(), (int)(this.m_20189_() + d1)));
                }
                int n = i;
                this.paddlePositions[n] = this.paddlePositions[n] + 0.3926991f;
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
    }

    public void updateLocalWindAngleAndSpeed() {
        double newDirection = this.getWind().angle;
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        if (this.windLerpTicks > 0) {
            float lerpStep = (float)(40 - this.windLerpTicks) / 40.0f;
            double lerpedRot = Math.round(Mth.m_14189_((float)lerpStep, (float)this.oldWind.angle, (float)((float)newDirection)));
            this.setWind(new Wind(this.oldWind.speed, Mth.m_14177_((float)Math.round(lerpedRot))));
            --this.windLerpTicks;
            return;
        }
        if (newDirection != (double)this.getWind().angle) {
            this.oldWind = this.getWind();
            this.windLerpTicks = 40;
        }
    }

    @Deprecated(forRemoval=true)
    public float[] getLocalWindAngleAndSpeed() {
        return new float[]{this.getLocalWindAngle(), this.getLocalWindSpeed()};
    }

    public float getLocalWindAngle() {
        return this.getWind().angle;
    }

    public float getLocalWindSpeed() {
        return Mth.m_14036_((float)this.getWind().speed, (float)0.0f, (float)0.2f);
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.f_11707_;
            }
            case ON_LAND: {
                return SoundEvents.f_11706_;
            }
        }
        return null;
    }

    public void setPaddleState(boolean pLeft, boolean pRight) {
        this.f_19804_.m_135381_(DATA_ID_PADDLE_LEFT, (Object)pLeft);
        this.f_19804_.m_135381_(DATA_ID_PADDLE_RIGHT, (Object)pRight);
    }

    public float getRowingTime(int pSide, float pLimbSwing) {
        return this.getPaddleState(pSide) ? Mth.m_144920_((float)(this.paddlePositions[pSide] - 0.3926991f), (float)this.paddlePositions[pSide], (float)pLimbSwing) : 0.0f;
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.f_19804_.m_135370_(side == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.m_6688_() != null;
    }

    public final void setWind(Wind wind) {
        this.f_19804_.m_135381_(DATA_ID_WIND_VECTOR, (Object)wind);
    }

    public final Wind getWind() {
        return (Wind)this.f_19804_.m_135370_(DATA_ID_WIND_VECTOR);
    }

    public void setImmobile(boolean immobile) {
        this.f_19804_.m_135381_(DATA_ID_IMMOBILE, (Object)immobile);
    }

    public boolean getImmobile() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_IMMOBILE);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.tickUpdateWind(false);
        this.setImmobile(pCompound.m_128471_("immobile"));
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("immobile", this.getImmobile());
    }

    public float getWindLocalRotation() {
        return Mth.m_14177_((float)(this.getLocalWindAngleAndSpeed()[0] - Mth.m_14177_((float)this.m_146908_())));
    }

    @Nullable
    public Entity m_5489_(ServerLevel destination) {
        Entity entity = super.m_5489_(destination);
        if (entity instanceof AbstractAlekiBoatEntity) {
            AbstractAlekiBoatEntity alekiBoat = (AbstractAlekiBoatEntity)entity;
            alekiBoat.windModel = WindModels.get((Level)destination);
        }
        return entity;
    }
}

