/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.PyrolyzerRecipeManager;
import cofh.thermal.core.util.recipes.machine.PyrolyzerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePyrolyzerScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class PyrolyzerRecipeCategory
extends ThermalRecipeCategory<PyrolyzerRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public PyrolyzerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<PyrolyzerRecipe> type) {
        super(guiHelper, icon, type);
        this.energyMod = () -> Float.valueOf(PyrolyzerRecipeManager.instance().getDefaultScale());
        this.background = guiHelper.drawableBuilder(MachinePyrolyzerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_pyrolyzer")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<PyrolyzerRecipe> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PyrolyzerRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List outputFluids = recipe.getOutputFluids();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i)).m_41764_((int)chance);
        }
        IRecipeSlotBuilder[] outputSlots = new IRecipeSlotBuilder[4];
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 15).addIngredients((Ingredient)inputs.get(0));
        outputSlots[0] = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 15);
        outputSlots[1] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 15);
        outputSlots[2] = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 33);
        outputSlots[3] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 33);
        for (int i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)outputSlots[i].addItemStack((ItemStack)outputs.get(i))).addTooltipCallback(TCoreJeiPlugin.defaultOutputTooltip((float)((Float)recipe.getOutputItemChances().get(i)).floatValue()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 141, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, outputFluids.isEmpty() ? Collections.emptyList() : List.of((FluidStack)outputFluids.get(0)))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)4000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(PyrolyzerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.progressBackground.draw(guiGraphics, 62, 24);
        this.tankBackground.draw(guiGraphics, 140, 10);
        this.speedBackground.draw(guiGraphics, 34, 33);
        if (!recipe.getOutputFluids().isEmpty()) {
            RenderHelper.drawFluid((GuiGraphics)guiGraphics, (int)62, (int)24, (FluidStack)((FluidStack)recipe.getOutputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(guiGraphics, 62, 24);
            this.progressFluid.draw(guiGraphics, 62, 24);
        } else {
            this.progress.draw(guiGraphics, 62, 24);
        }
        this.speed.draw(guiGraphics, 34, 33);
    }
}

