/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.registry;

import com.smashingmods.chemlib.common.blocks.ChemicalLiquidBlock;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class FluidRegistry {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"chemlib");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"chemlib");
    public static final DeferredRegister<Block> LIQUID_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chemlib");
    public static final DeferredRegister<Item> BUCKETS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"chemlib");

    protected static void registerFluid(String pName, FluidType.Properties pFluidProperties, final int pColor, int pSlopeFindDistance, int pDecreasePerBlock) {
        var ref = new Object(){
            ForgeFlowingFluid.Properties properties = null;
        };
        RegistryObject fluidType = FLUID_TYPES.register(pName, () -> new FluidType(pFluidProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return new ResourceLocation("block/water_still");
                    }

                    public ResourceLocation getFlowingTexture() {
                        return new ResourceLocation("block/water_flow");
                    }

                    public ResourceLocation getOverlayTexture() {
                        return new ResourceLocation("block/water_overlay");
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return new ResourceLocation("minecraft", "textures/misc/underwater.png");
                    }

                    public int getTintColor() {
                        return pColor;
                    }

                    public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                        return pColor;
                    }
                });
            }
        });
        RegistryObject fluidSource = FLUIDS.register(String.format("%s_fluid", pName), () -> new ForgeFlowingFluid.Source(ref.properties));
        RegistryObject fluidFlowing = FLUIDS.register(String.format("%s_flowing", pName), () -> new ForgeFlowingFluid.Flowing(ref.properties));
        RegistryObject liquidBlock = LIQUID_BLOCKS.register(pName, () -> new ChemicalLiquidBlock((Supplier<? extends FlowingFluid>)fluidSource, pName));
        RegistryObject bucket = BUCKETS.register(String.format("%s_bucket", pName), () -> new BucketItem((Supplier)fluidSource, new Item.Properties().m_41487_(1)));
        ref.properties = new ForgeFlowingFluid.Properties((Supplier)fluidType, (Supplier)fluidSource, (Supplier)fluidFlowing).slopeFindDistance(pSlopeFindDistance).levelDecreasePerBlock(pDecreasePerBlock).block((Supplier)liquidBlock).bucket((Supplier)bucket);
    }

    public static Stream<Fluid> getFluidsAsStream() {
        return FLUIDS.getEntries().stream().map(RegistryObject::get);
    }

    public static Stream<FluidType> getFluidTypesAsStream() {
        return FluidRegistry.getFluidsAsStream().map(Fluid::getFluidType);
    }

    public static Stream<ForgeFlowingFluid.Source> getSourceFluidsAsStream() {
        return FluidRegistry.getFluidsAsStream().filter(fluid -> fluid instanceof ForgeFlowingFluid.Source).map(fluid -> (ForgeFlowingFluid.Source)fluid);
    }

    public static Stream<ForgeFlowingFluid.Source> getLiquidSourceFluidsAsStream() {
        return FluidRegistry.getSourceFluidsAsStream().filter(source -> !source.getFluidType().isLighterThanAir());
    }

    public static Stream<ForgeFlowingFluid.Source> getGasSourceFluidsAsStream() {
        return FluidRegistry.getSourceFluidsAsStream().filter(source -> source.getFluidType().isLighterThanAir());
    }

    public static List<Fluid> getFluids() {
        return FluidRegistry.getFluidsAsStream().collect(Collectors.toList());
    }

    public static List<Fluid> getSourceFluids() {
        return FluidRegistry.getSourceFluidsAsStream().collect(Collectors.toList());
    }

    public static List<Fluid> getLiquidSourceFluids() {
        return FluidRegistry.getLiquidSourceFluidsAsStream().collect(Collectors.toList());
    }

    public static List<Fluid> getGasSourceFluids() {
        return FluidRegistry.getGasSourceFluidsAsStream().collect(Collectors.toList());
    }

    public static Optional<FluidType> getFluidTypeByName(String pName) {
        return FluidRegistry.getFluidTypesAsStream().filter(fluidType -> Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey(fluidType)).m_135815_().equals(pName)).findFirst();
    }

    public static Optional<ForgeFlowingFluid.Source> getSourceFluidByName(String pName) {
        return FluidRegistry.getSourceFluidsAsStream().filter(source -> Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)source.getFluidType())).m_135815_().equals(pName)).findFirst();
    }

    public static Optional<ForgeFlowingFluid.Source> getLiquidSourceFluidByName(String pName) {
        return FluidRegistry.getLiquidSourceFluidsAsStream().filter(source -> Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)source.getFluidType())).m_135815_().equals(pName)).findFirst();
    }

    public static Optional<ForgeFlowingFluid.Source> getGasSourceFluidByName(String pName) {
        return FluidRegistry.getGasSourceFluidsAsStream().filter(source -> Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)source.getFluidType())).m_135815_().equals(pName)).findFirst();
    }

    public static Stream<LiquidBlock> getLiquidBlocks() {
        return LIQUID_BLOCKS.getEntries().stream().map(RegistryObject::get).map(block -> (LiquidBlock)block);
    }

    public static Stream<BucketItem> getBuckets() {
        return BUCKETS.getEntries().stream().map(RegistryObject::get).map(item -> (BucketItem)item);
    }

    public static List<BucketItem> getAllSortedBuckets() {
        LinkedList<BucketItem> buckets = new LinkedList<BucketItem>(FluidRegistry.getElementBuckets());
        buckets.addAll(FluidRegistry.getSortedCompoundBuckets());
        return buckets;
    }

    public static List<BucketItem> getElementBuckets() {
        TreeMap bucketMap = new TreeMap();
        for (BucketItem bucket : BUCKETS.getEntries().stream().map(RegistryObject::get).map(item -> (BucketItem)item).toList()) {
            String path = StringUtils.removeEnd((String)((ResourceKey)ForgeRegistries.FLUIDS.getResourceKey((Object)bucket.getFluid()).get()).m_135782_().m_135815_(), (String)"_fluid");
            ItemRegistry.getElementByName(path).ifPresent(elementItem -> bucketMap.put(elementItem.getAtomicNumber(), bucket));
        }
        return bucketMap.values().stream().toList();
    }

    public static List<BucketItem> getCompoundBuckets() {
        ArrayList<BucketItem> buckets = new ArrayList<BucketItem>();
        for (BucketItem bucket : BUCKETS.getEntries().stream().map(RegistryObject::get).map(item -> (BucketItem)item).toList()) {
            String path = StringUtils.removeEnd((String)((ResourceKey)ForgeRegistries.FLUIDS.getResourceKey((Object)bucket.getFluid()).get()).m_135782_().m_135815_(), (String)"_fluid");
            ItemRegistry.getCompoundByName(path).ifPresent(compoundItem -> buckets.add(bucket));
        }
        return buckets;
    }

    public static List<BucketItem> getSortedCompoundBuckets() {
        List<BucketItem> buckets = FluidRegistry.getCompoundBuckets();
        buckets.sort((b1, b2) -> b1.getFluid().getFluidType().toString().compareToIgnoreCase(b2.getFluid().getFluidType().toString()));
        return buckets;
    }

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
        FLUID_TYPES.register(eventBus);
        LIQUID_BLOCKS.register(eventBus);
        BUCKETS.register(eventBus);
    }
}

