/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.client.container;

import com.smashingmods.alchemistry.common.block.atomizer.AtomizerBlockEntity;
import com.smashingmods.alchemistry.common.block.combiner.CombinerBlockEntity;
import com.smashingmods.alchemistry.common.block.compactor.CompactorBlockEntity;
import com.smashingmods.alchemistry.common.block.dissolver.DissolverBlockEntity;
import com.smashingmods.alchemistry.common.block.fission.FissionControllerBlockEntity;
import com.smashingmods.alchemistry.common.block.fusion.FusionControllerBlockEntity;
import com.smashingmods.alchemistry.common.block.liquifier.LiquifierBlockEntity;
import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipe;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipe;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipe;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipe;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.recipe.ProcessingRecipe;
import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeDisplayUtil {
    public static List<Component> getItemTooltipComponent(ItemStack pItemStack, MutableComponent pComponent) {
        ArrayList<Component> components = new ArrayList<Component>();
        String namespace = StringUtils.capitalize((String)Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItemStack.m_41720_())).m_135827_());
        components.add((Component)pComponent.m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
        components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%dx %s", pItemStack.m_41613_(), pItemStack.m_41720_().m_41466_().getString()))));
        Item item = pItemStack.m_41720_();
        if (item instanceof Chemical) {
            ChemicalItem chemicalItem;
            Chemical chemical = (Chemical)item;
            String abbreviation = chemical.getAbbreviation();
            if (chemical instanceof ElementItem) {
                ElementItem element = (ElementItem)chemical;
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", abbreviation, element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
            } else if (chemical instanceof ChemicalItem && !(chemicalItem = (ChemicalItem)chemical).getItemType().equals((Object)ChemicalItemType.COMPOUND)) {
                Chemical chemical2 = chemicalItem.getChemical();
                if (chemical2 instanceof ElementItem) {
                    ElementItem element = (ElementItem)chemical2;
                    components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", chemicalItem.getAbbreviation(), element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
                    components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
                }
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(chemicalItem.getAbbreviation())).m_130940_(ChatFormatting.DARK_AQUA));
            } else if (chemical instanceof CompoundItem) {
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(abbreviation)).m_130940_(ChatFormatting.DARK_AQUA));
            }
        }
        components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(namespace)).m_130940_(ChatFormatting.BLUE));
        return components;
    }

    public static Pair<ResourceLocation, String> getSearchablePair(ProcessingRecipe pRecipe) {
        if (pRecipe instanceof AtomizerRecipe) {
            AtomizerRecipe atomizerRecipe = (AtomizerRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.FLUIDS.getKey((Object)atomizerRecipe.getInput().getFluid());
            String right = atomizerRecipe.getInput().getDisplayName().getString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof CombinerRecipe) {
            CombinerRecipe combinerRecipe = (CombinerRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.ITEMS.getKey((Object)combinerRecipe.getOutput().m_41720_());
            String right = combinerRecipe.getOutput().m_41720_().m_41466_().toString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof CompactorRecipe) {
            CompactorRecipe compactorRecipe = (CompactorRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.ITEMS.getKey((Object)compactorRecipe.getOutput().m_41720_());
            String right = compactorRecipe.getOutput().m_41720_().m_41466_().toString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof DissolverRecipe) {
            DissolverRecipe dissolverRecipe = (DissolverRecipe)pRecipe;
            ResourceLocation left = dissolverRecipe.getInput().getRegistryName();
            String right = dissolverRecipe.getInput().getRegistryName().m_135815_().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof FissionRecipe) {
            FissionRecipe fissionRecipe = (FissionRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.ITEMS.getKey((Object)fissionRecipe.getInput().m_41720_());
            String right = fissionRecipe.getInput().m_41720_().m_41466_().toString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof FusionRecipe) {
            FusionRecipe fusionRecipe = (FusionRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.ITEMS.getKey((Object)fusionRecipe.getOutput().m_41720_());
            String right = fusionRecipe.getOutput().m_41720_().m_41466_().toString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        if (pRecipe instanceof LiquifierRecipe) {
            LiquifierRecipe liquifierRecipe = (LiquifierRecipe)pRecipe;
            ResourceLocation left = ForgeRegistries.FLUIDS.getKey((Object)liquifierRecipe.getOutput().getFluid());
            String right = liquifierRecipe.getOutput().getDisplayName().toString().toLowerCase();
            return Pair.of((Object)left, (Object)right);
        }
        return Pair.of((Object)new ResourceLocation("minecraft:empty"), (Object)"");
    }

    public static ItemStack getTarget(ProcessingRecipe pRecipe) {
        if (pRecipe instanceof AtomizerRecipe) {
            AtomizerRecipe atomizerRecipe = (AtomizerRecipe)pRecipe;
            return atomizerRecipe.getOutput();
        }
        if (pRecipe instanceof CombinerRecipe) {
            CombinerRecipe combinerRecipe = (CombinerRecipe)pRecipe;
            return combinerRecipe.getOutput();
        }
        if (pRecipe instanceof CompactorRecipe) {
            CompactorRecipe compactorRecipe = (CompactorRecipe)pRecipe;
            return compactorRecipe.getOutput();
        }
        if (pRecipe instanceof DissolverRecipe) {
            DissolverRecipe dissolverRecipe = (DissolverRecipe)pRecipe;
            return !dissolverRecipe.getInput().toStacks().isEmpty() ? (ItemStack)dissolverRecipe.getInput().toStacks().get(0) : ItemStack.f_41583_;
        }
        if (pRecipe instanceof FissionRecipe) {
            FissionRecipe fissionRecipe = (FissionRecipe)pRecipe;
            return fissionRecipe.getInput();
        }
        if (pRecipe instanceof FusionRecipe) {
            FusionRecipe fusionRecipe = (FusionRecipe)pRecipe;
            return fusionRecipe.getOutput();
        }
        if (pRecipe instanceof LiquifierRecipe) {
            LiquifierRecipe liquifierRecipe = (LiquifierRecipe)pRecipe;
            return liquifierRecipe.getInput().toStacks().isEmpty() ? (ItemStack)liquifierRecipe.getInput().toStacks().get(0) : ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getRecipeInputByIndex(ProcessingRecipe pRecipe, int pIndex) {
        AtomicReference<ItemStack> toReturn = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        if (pRecipe instanceof AtomizerRecipe) {
            AtomizerRecipe atomizerRecipe = (AtomizerRecipe)pRecipe;
            return atomizerRecipe.getOutput();
        }
        if (pRecipe instanceof CombinerRecipe) {
            CombinerRecipe combinerRecipe = (CombinerRecipe)pRecipe;
            if (pIndex >= 0 && pIndex < combinerRecipe.getInput().size()) {
                new Random().ints(0, ((IngredientStack)combinerRecipe.getInput().get(pIndex)).toStacks().size()).findFirst().ifPresent(random -> toReturn.set((ItemStack)((IngredientStack)combinerRecipe.getInput().get(pIndex)).toStacks().get(random)));
            }
        } else if (pRecipe instanceof CompactorRecipe) {
            CompactorRecipe compactorRecipe = (CompactorRecipe)pRecipe;
            new Random().ints(0, compactorRecipe.getInput().toStacks().size()).findFirst().ifPresent(random -> toReturn.set((ItemStack)compactorRecipe.getInput().toStacks().get(random)));
        } else {
            if (pRecipe instanceof DissolverRecipe) {
                DissolverRecipe dissolverRecipe = (DissolverRecipe)pRecipe;
                return !dissolverRecipe.getInput().toStacks().isEmpty() ? (ItemStack)dissolverRecipe.getInput().toStacks().get(0) : ItemStack.f_41583_;
            }
            if (pRecipe instanceof FissionRecipe) {
                FissionRecipe fissionRecipe = (FissionRecipe)pRecipe;
                return fissionRecipe.getInput();
            }
            if (pRecipe instanceof FusionRecipe) {
                FusionRecipe fusionRecipe = (FusionRecipe)pRecipe;
                return fusionRecipe.getOutput();
            }
            if (pRecipe instanceof LiquifierRecipe) {
                LiquifierRecipe liquifierRecipe = (LiquifierRecipe)pRecipe;
                return liquifierRecipe.getInput().toStacks().isEmpty() ? (ItemStack)liquifierRecipe.getInput().toStacks().get(0) : ItemStack.f_41583_;
            }
        }
        return toReturn.get();
    }

    public static int getInputSize(AbstractProcessingBlockEntity pBlockEntity) {
        if (pBlockEntity instanceof AtomizerBlockEntity) {
            return 1;
        }
        if (pBlockEntity instanceof CombinerBlockEntity) {
            return 4;
        }
        if (pBlockEntity instanceof CompactorBlockEntity) {
            return 1;
        }
        if (pBlockEntity instanceof DissolverBlockEntity) {
            return 1;
        }
        if (pBlockEntity instanceof FissionControllerBlockEntity) {
            return 1;
        }
        if (pBlockEntity instanceof FusionControllerBlockEntity) {
            return 2;
        }
        if (pBlockEntity instanceof LiquifierBlockEntity) {
            return 1;
        }
        return 0;
    }
}

