/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.dissolver;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.dissolver.DissolverMenu;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractInventoryBlockEntity;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DissolverBlockEntity
extends AbstractInventoryBlockEntity {
    private DissolverRecipe currentRecipe;
    private ResourceLocation recipeId;
    private final NonNullList<ItemStack> internalBuffer = NonNullList.m_182647_((int)64);
    private boolean valid = false;

    public DissolverBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", (BlockEntityType)BlockEntityRegistry.DISSOLVER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setEnergyPerTick((Integer)Config.Common.dissolverEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.dissolverTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getDissolverRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void tick() {
        if (!(this.isProcessingPaused() || this.getInputHandler().getStackInSlot(0).m_41619_() && this.internalBuffer.isEmpty())) {
            super.tick();
            this.processBuffer();
        }
    }

    public void updateRecipe() {
        if (!(this.f_58857_ == null || this.f_58857_.m_5776_() || this.isRecipeLocked() || this.getInputHandler().getStackInSlot(0).m_41619_())) {
            RecipeRegistry.getDissolverRecipe(recipe -> recipe.matches(this.getInputHandler().getStackInSlot(0)), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe);
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            DissolverRecipe tempRecipe = this.currentRecipe.copy();
            ItemStack input = this.getInputHandler().getStackInSlot(0).m_41777_();
            return this.getEnergyHandler().getEnergyStored() >= this.getEnergyPerTick() && tempRecipe.matches(input) && input.m_41613_() >= tempRecipe.getInput().getCount() && this.internalBuffer.isEmpty();
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            DissolverRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getInputHandler().decrementSlot(0, tempRecipe.getInput().getCount());
            this.internalBuffer.addAll(tempRecipe.getOutput().calculateOutput());
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    private void processBuffer() {
        block0: for (int i = 0; i < this.internalBuffer.size(); ++i) {
            ItemStack bufferStack = ((ItemStack)this.internalBuffer.get(i)).m_41777_();
            for (int j = 0; j < this.getOutputHandler().getStacks().size(); ++j) {
                ItemStack slotStack = this.getOutputHandler().getStackInSlot(j).m_41777_();
                if (!slotStack.m_41619_() && (!ItemStack.m_150942_((ItemStack)bufferStack, (ItemStack)slotStack) || bufferStack.m_41613_() + slotStack.m_41613_() > slotStack.m_41741_())) continue;
                this.valid = true;
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.getOutputHandler(), (ItemStack)bufferStack, (boolean)false);
                this.valid = false;
                this.internalBuffer.remove(i);
                continue block0;
            }
        }
        this.setCanProcess(this.canProcessRecipe());
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof DissolverRecipe) {
            DissolverRecipe dissolverRecipe;
            this.currentRecipe = dissolverRecipe = (DissolverRecipe)pRecipe;
        }
    }

    public DissolverRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<DissolverRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<DissolverRecipe>(RecipeRegistry.getDissolverRecipes(this.f_58857_));
        }
        return new LinkedList<DissolverRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.dissolverEnergyCapacity.get()){

            protected void onEnergyChanged() {
                DissolverBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(1){

            protected void onContentsChanged(int pSlot) {
                DissolverBlockEntity.this.updateRecipe();
                DissolverBlockEntity.this.setCanProcess(DissolverBlockEntity.this.canProcessRecipe());
                DissolverBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int pSlot, @Nonnull ItemStack pItemStack) {
                if (DissolverBlockEntity.this.currentRecipe != null && DissolverBlockEntity.this.isRecipeLocked()) {
                    return DissolverBlockEntity.this.currentRecipe.getInput().matches(pItemStack);
                }
                return super.isItemValid(pSlot, pItemStack);
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(12){

            @Nonnull
            public ItemStack insertItem(int pSlot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(pSlot, stack, simulate);
            }

            public boolean isItemValid(int pSlot, ItemStack pItemStack) {
                return DissolverBlockEntity.this.valid;
            }

            protected void onContentsChanged(int pSlot) {
                DissolverBlockEntity.this.m_6596_();
            }
        };
    }

    protected void m_183515_(CompoundTag pTag) {
        ListTag bufferTag = new ListTag();
        this.internalBuffer.stream().filter(itemStack -> !itemStack.m_41619_()).forEach(itemStack -> bufferTag.add((Object)itemStack.m_41739_(new CompoundTag())));
        pTag.m_128365_("buffer", (Tag)bufferTag);
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        ListTag bufferTag = pTag.m_128437_("buffer", 10);
        bufferTag.stream().filter(tag -> tag instanceof CompoundTag).map(CompoundTag.class::cast).map(ItemStack::m_41712_).forEach(arg_0 -> this.internalBuffer.add(arg_0));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getDissolverRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new DissolverMenu(pContainerId, pInventory, (BlockEntity)this);
    }

    public void dropContents(Level pLevel, BlockPos pBlockPos) {
        if (!pLevel.m_5776_()) {
            Containers.m_19010_((Level)pLevel, (BlockPos)pBlockPos, this.internalBuffer);
        }
        super.dropContents(pLevel, pBlockPos);
    }
}

