/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.atomizer;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipe;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class AtomizerRecipeSerializer<T extends AtomizerRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;

    public AtomizerRecipeSerializer(IFactory<T> pFactory) {
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String recipeGroup;
        String string = recipeGroup = pSerializedRecipe.has("group") ? pSerializedRecipe.get("group").getAsString() : "atomizer";
        if (!pSerializedRecipe.has("input")) {
            throw new JsonSyntaxException("Missing input, expected to find an object.");
        }
        JsonObject inputObject = pSerializedRecipe.getAsJsonObject("input");
        ResourceLocation fluidLocation = new ResourceLocation(inputObject.get("fluid").getAsString());
        int fluidAmount = inputObject.has("amount") ? inputObject.get("amount").getAsInt() : 1000;
        FluidStack input = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation)), fluidAmount);
        if (!pSerializedRecipe.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object.");
        }
        ItemStack output = ShapedRecipe.m_151274_((JsonObject)pSerializedRecipe.getAsJsonObject("result"));
        return (T)((Object)((AtomizerRecipe)((Object)this.factory.create(pRecipeId, recipeGroup, input, output))));
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String recipeGroup = pBuffer.m_130136_(Short.MAX_VALUE);
        FluidStack input = pBuffer.readFluidStack();
        ItemStack output = pBuffer.m_130267_();
        return (T)((Object)((AtomizerRecipe)((Object)this.factory.create(pRecipeId, recipeGroup, input, output))));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.writeFluidStack(((AtomizerRecipe)((Object)pRecipe)).getInput());
        pBuffer.m_130055_(((AtomizerRecipe)((Object)pRecipe)).getOutput());
    }

    public static interface IFactory<T extends Recipe<Inventory>> {
        public T create(ResourceLocation var1, String var2, FluidStack var3, ItemStack var4);
    }
}

