/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.combiner;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CombinerRecipeSerializer<T extends CombinerRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;

    public CombinerRecipeSerializer(IFactory<T> pFactory) {
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String group = pSerializedRecipe.get("group").getAsString();
        JsonArray inputJson = pSerializedRecipe.getAsJsonArray("input");
        LinkedHashSet<IngredientStack> input = new LinkedHashSet<IngredientStack>();
        inputJson.forEach(element -> input.add(IngredientStack.fromJson((JsonObject)element.getAsJsonObject())));
        ItemStack output = pSerializedRecipe.get("result").isJsonObject() ? CraftingHelper.getItemStack((JsonObject)pSerializedRecipe.getAsJsonObject("result"), (boolean)true, (boolean)true) : CraftingHelper.getItemStack((JsonObject)pSerializedRecipe.getAsJsonObject("item"), (boolean)true, (boolean)true);
        return (T)((Object)((CombinerRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String group = pBuffer.m_130136_(Short.MAX_VALUE);
        int inputCount = pBuffer.readInt();
        LinkedHashSet<IngredientStack> inputList = new LinkedHashSet<IngredientStack>();
        for (int i = 0; i < inputCount; ++i) {
            inputList.add(IngredientStack.fromNetwork((FriendlyByteBuf)pBuffer));
        }
        ItemStack output = pBuffer.m_130267_();
        return (T)((Object)((CombinerRecipe)((Object)this.factory.create(pRecipeId, group, inputList, output))));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.writeInt(((CombinerRecipe)((Object)pRecipe)).getInput().size());
        for (int i = 0; i < ((CombinerRecipe)((Object)pRecipe)).getInput().size(); ++i) {
            ((IngredientStack)((CombinerRecipe)((Object)pRecipe)).getInput().get(i)).toNetwork(pBuffer);
        }
        pBuffer.writeItemStack(((CombinerRecipe)((Object)pRecipe)).getOutput(), true);
    }

    public static interface IFactory<T extends Recipe<Inventory>> {
        public T create(ResourceLocation var1, String var2, Set<IngredientStack> var3, ItemStack var4);
    }
}

