/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.compactor;

import com.google.gson.JsonObject;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class CompactorRecipeSerializer<T extends CompactorRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;

    public CompactorRecipeSerializer(IFactory<T> pFactory) {
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String group = pSerializedRecipe.has("group") ? pSerializedRecipe.get("group").getAsString() : "compactor";
        IngredientStack input = IngredientStack.fromJson((JsonObject)pSerializedRecipe.getAsJsonObject("input"));
        ItemStack output = ShapedRecipe.m_151274_((JsonObject)pSerializedRecipe.getAsJsonObject("result"));
        return (T)((Object)((CompactorRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    @Nullable
    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String group = pBuffer.m_130136_(Short.MAX_VALUE);
        IngredientStack input = IngredientStack.fromNetwork((FriendlyByteBuf)pBuffer);
        ItemStack output = pBuffer.m_130267_();
        return (T)((Object)((CompactorRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        ((CompactorRecipe)((Object)pRecipe)).getInput().toNetwork(pBuffer);
        pBuffer.m_130055_(((CompactorRecipe)((Object)pRecipe)).getOutput());
    }

    public static interface IFactory<T extends Recipe<Inventory>> {
        public T create(ResourceLocation var1, String var2, IngredientStack var3, ItemStack var4);
    }
}

