/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.Gunsmithing;
import com.nukateam.cgs.common.faundation.registry.items.AttachmentItems;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicGunRenderer;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class LauncherAnimator
extends GunAnimator {
    public static final String EMPTY = "empty";
    public static final String RELOAD_BALLISTA_MANUAL = "reload_ballista_manual";
    public static final String RELOAD_BALLISTA_AUTO = "reload_ballista_auto";
    public static final String RELOAD_AUTO = "reload_auto";
    public static final String SHOT_BALLISTA = "shot_ballista";
    public static final String HIDE_SIGHTS = "hide_sights";
    private int ammoCount;
    private boolean isBallista;
    private boolean isAutoLauncher;
    private boolean hasAir;
    private boolean hasScope;
    protected final AnimationController<GunAnimator> MISC_CONTROLLER = this.createController("misc_controller", this.animateMisc());

    public LauncherAnimator(ItemDisplayContext transformType, DynamicGunRenderer<GunAnimator> renderer) {
        super(transformType, renderer);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.MISC_CONTROLLER});
    }

    protected void tickStart() {
        super.tickStart();
        Item magazineAttachment = GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack()).m_41720_();
        try {
            if (this.itemStack.m_41720_() instanceof WeaponItem) {
                GunData data = this.getGunData();
                this.ammoCount = GunStateHelper.getAmmoCount((GunData)data);
                this.isBallista = magazineAttachment == AttachmentItems.BALLISTAZOOKA.get();
                this.isAutoLauncher = magazineAttachment == AttachmentItems.AUTO_LAUNCHER.get();
                this.hasAir = GunUtils.hasAir(data);
                this.hasScope = GunStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)AttachmentType.SCOPE);
            }
        }
        catch (IllegalStateException e) {
            Gunsmithing.LOGGER.error(e.getMessage());
        }
    }

    protected RawAnimation getHoldAnimation(AnimationState<GunAnimator> event) {
        if (this.ammoCount == 0) {
            return this.playGunAnim(EMPTY, Animation.LoopType.LOOP);
        }
        return super.getHoldAnimation(event);
    }

    protected RawAnimation getShootingAnimation(AnimationState<GunAnimator> event) {
        if (this.isBallista) {
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(SHOT_BALLISTA), Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, this.rate, new String[]{SHOT_BALLISTA});
            return animation;
        }
        return super.getShootingAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<GunAnimator> event) {
        if (this.isBallista) {
            if (this.hasAir) {
                RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_BALLISTA_AUTO), Animation.LoopType.PLAY_ONCE);
                this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_BALLISTA_AUTO});
                return animation;
            }
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_BALLISTA_MANUAL), Animation.LoopType.PLAY_ONCE);
            this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_BALLISTA_MANUAL});
            return animation;
        }
        if (this.isAutoLauncher) {
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_AUTO), Animation.LoopType.PLAY_ONCE);
            this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_AUTO});
            return animation;
        }
        return super.getDefaultReloadAnimation(event);
    }

    private AnimationController.AnimationStateHandler<GunAnimator> animateMisc() {
        return event -> {
            if (this.hasScope) {
                RawAnimation hideSights = RawAnimation.begin().then(this.getGunAnim(HIDE_SIGHTS), Animation.LoopType.LOOP);
                return event.setAndContinue(hideSights);
            }
            return PlayState.STOP;
        };
    }
}

