/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.ntgl;

import com.nukateam.cgs.Gunsmithing;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoHolders;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.CombustibleItem;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class CgsAmmo {
    public static AmmoHolder AIR = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("air")).isAcceptable(CgsAmmo::isAir).value(s -> (int)BacktankUtil.getAir((ItemStack)s)).onConsume(CgsAmmo::onConsumeAir).build();
    public static final AmmoHolder BURNABLE = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("burnable")).isAcceptable(CgsAmmo::isBurnable).value(stack -> ForgeHooks.getBurnTime((ItemStack)stack, null)).onConsume(AmmoHolders::consumeBurnable).build();
    public static final AmmoHolder BLAZE_CAKE = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("blaze_cake")).isAcceptable(stack -> stack.m_41720_() == AllItems.BLAZE_CAKE.get()).value(stack -> 20000).descriptionId(s -> ((CombustibleItem)AllItems.BLAZE_CAKE.get()).m_5524_()).build();

    public static void register() {
        AmmoHolder.registerType((AmmoHolder)AIR);
        AmmoHolder.registerType((AmmoHolder)BURNABLE);
        AmmoHolder.registerType((AmmoHolder)BLAZE_CAKE);
    }

    private static boolean isBurnable(ItemStack ammoStack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)ammoStack, null);
        return ammoStack.m_41720_() != AllItems.BLAZE_CAKE.get() && burnTime > 0;
    }

    private static Boolean isAir(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof BacktankItem && BacktankUtil.hasAirRemaining((ItemStack)stack);
    }

    private static List<ItemStack> onConsumeAir(ItemStack stack, Integer amount) {
        float tankAir = BacktankUtil.getAir((ItemStack)stack);
        ItemStack tank = new ItemStack((ItemLike)stack.m_41720_());
        GunUtils.setAir(tank, Math.max(0.0f, tankAir - (float)amount.intValue()));
        GunUtils.consumeAir(tank, amount.intValue());
        return List.of(tank);
    }
}

