/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.Texture;
import journeymap.client.ui.GuiHooks;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(GuiGraphics graphics, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true, 0.0);
    }

    public static void drawCenteredLabel(GuiGraphics graphics, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawCenteredLabel(GuiGraphics graphics, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, double rotation) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, false, rotation);
    }

    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(PoseStack poseStack, MultiBufferSource buffers, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            DrawUtil.drawBatchLabel(poseStack, (Component)Component.m_237113_((String)lines[0]), buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        double vpad = fontRenderer.m_92718_() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.m_92895_(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        if (lines.length > 1) {
            switch (vAlign) {
                case Above: {
                    y -= lineHeight * (double)lines.length;
                    bgHeight += vpad / 2.0;
                    break;
                }
                case Middle: {
                    y -= bgHeight / 2.0;
                    break;
                }
            }
        }
        for (String line : lines) {
            DrawUtil.drawBatchLabel(poseStack, (Component)Component.m_237113_((String)line), buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
            bgColor = null;
            y += lineHeight;
        }
    }

    public static void drawLabel(GuiGraphics graphics, String text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            bgWidth = fontRenderer.m_92895_(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.m_92895_(text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.m_92718_()) {
            --height;
        }
        graphics.m_280168_().m_85836_();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                graphics.m_280168_().m_85841_((float)fontScale, (float)fontScale, 1.0f);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign) {
                case Left: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case Center: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case Right: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                Objects.requireNonNull(fontRenderer);
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign) {
                case Above: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.m_92718_() ? 1 : 0));
                    break;
                }
                case Middle: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case Below: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                graphics.m_280168_().m_85837_(x, y, 0.0);
                graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(-rotation)));
                graphics.m_280168_().m_85837_(-x, -y, 0.0);
            }
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(graphics.m_280168_(), rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            if (alpha < 1.0f) {
                color = RGB.toArbg(color, alpha);
            }
            graphics.m_280168_().m_85837_((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
            graphics.m_280056_(fontRenderer, text, (int)Math.floor(textX), (int)Math.floor(textY), color.intValue(), fontShadow);
        }
        finally {
            graphics.m_280168_().m_85849_();
        }
    }

    public static void drawBatchLabel(PoseStack poseStack, Component text, MultiBufferSource buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawBatchLabel(PoseStack poseStack, Component text, MultiBufferSource buffers, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawBatchLabel(PoseStack poseStack, Component text, MultiBufferSource buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            bgWidth = fontRenderer.m_92852_((FormattedText)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(PoseStack poseStack, Component text, MultiBufferSource buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.m_92852_((FormattedText)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.m_92718_()) {
            --height;
        }
        poseStack.m_85836_();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.m_85841_((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.m_92718_() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            poseStack.m_85837_(x, y, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-rotation)));
            poseStack.m_85837_(-x, -y, 0.0);
        }
        Matrix4f matrixPos = poseStack.m_85850_().m_252922_();
        if (drawRect) {
            int backgroundColor = Minecraft.m_91087_().f_91066_.m_92170_(bgAlpha);
            RenderWrapper.disableDepthTest();
            int hpad = 2;
            DrawUtil.drawRectangle(poseStack, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        poseStack.m_85837_((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        fontRenderer.m_272077_(text, textX, textY, color, fontShadow, matrixPos, buffers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        RenderWrapper.disableDepthTest();
        RenderWrapper.depthMask(false);
        poseStack.m_85849_();
    }

    public static int getLabelHeight(Font fr, boolean fontShadow) {
        int vpad = fr.m_92718_() ? 0 : (fontShadow ? 6 : 4);
        Objects.requireNonNull(fr);
        return 9 + vpad;
    }

    public static void drawImage(PoseStack poseStack, Texture texture, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, flip, rotation);
    }

    public static void drawImage(PoseStack poseStack, Texture texture, float alpha, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, 0xFFFFFF, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawClampedImage(PoseStack poseStack, Texture texture, double x, double y, float scale, double rotation) {
        DrawUtil.drawClampedImage(poseStack, texture, 0xFFFFFF, 1.0f, x, y, scale, rotation);
    }

    public static void drawClampedImage(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredImage(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredSprite(PoseStack poseStack, Texture texture, double displayWidth, double displayHeight, double spriteX, double spriteY, double spriteWidth, double spriteHeight, Integer color, float alpha, double x, double y, float scale, double rotation) {
        double texWidth = texture.getWidth();
        double texHeight = texture.getHeight();
        double minU = Math.max(0.0, spriteX / texWidth);
        double minV = Math.max(0.0, spriteY / texHeight);
        double maxU = Math.min(1.0, (spriteX + spriteWidth) / texWidth);
        double maxV = Math.min(1.0, (spriteY + spriteHeight) / texHeight);
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, displayWidth * (double)scale, displayHeight * (double)scale, minU, minV, maxU, maxV, rotation, false, true, 770, 771, false);
    }

    public static void drawColoredImage(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, texture.getWidth(), texture.getHeight(), false, rotation);
    }

    public static void drawWaypointIcon(PoseStack poseStack, Texture texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = texture.getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(poseStack, texture, color, alpha, drawX, drawY, width, height, false, rotation);
    }

    public static void drawColoredImage(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, int width, int height, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, width, height, false, rotation);
    }

    public static void drawQuad(PoseStack poseStack, Texture texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, 0xFFFFFF, 1.0f, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawQuad(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(PoseStack poseStack, Texture texture, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        poseStack.m_85836_();
        try {
            RenderWrapper.setShader(GameRenderer::m_172817_);
            RenderWrapper.activeTexture(33984);
            RenderWrapper.bindTexture(texture.getTextureId());
            RenderWrapper.setShaderTexture(0, texture.getTextureId());
            if (blend) {
                RenderWrapper.enableBlend();
                RenderWrapper.blendFuncSeparate(glBlendSfactor, glBlendDFactor, 1, 0);
            }
            RenderWrapper.enableTexture();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (blend) {
                float[] c = RGB.floats(color);
                RenderWrapper.setColor4f(c[0], c[1], c[2], alpha);
            } else {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, alpha);
            }
            RenderWrapper.texParameter(3553, 10241, 9729);
            RenderWrapper.texParameter(3553, 10240, 9729);
            int texEdgeBehavior = clampTexture ? 33071 : 10497;
            RenderWrapper.texParameter(3553, 10242, texEdgeBehavior);
            RenderWrapper.texParameter(3553, 10243, texEdgeBehavior);
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.m_85837_(transX, transY, 0.0);
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)rotation));
                poseStack.m_85837_(-transX, -transY, 0.0);
            }
            double direction = flip ? -maxU : maxU;
            RenderWrapper.disableTexture();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            DrawUtil.addVertexWithUV(poseStack, buffer, x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x, y, zLevel, minU, minV);
            tessellator.m_85914_();
            RenderWrapper.enableTexture();
            RenderWrapper.enableBlend();
            if (blend) {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                if (glBlendSfactor != 770 || glBlendDFactor != 771) {
                    RenderWrapper.enableBlend();
                    RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
                }
            }
        }
        finally {
            poseStack.m_85849_();
        }
    }

    public static void drawRectangle(PoseStack poseStack, double x, double y, double width, double height, int color, float alpha) {
        int[] rgba = RGB.ints(color, alpha);
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.defaultBlendFunc();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderWrapper.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), bufferBuilder, x, height + y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), bufferBuilder, x + width, height + y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), bufferBuilder, x + width, y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), bufferBuilder, x, y, zLevel, rgba);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.disableBlend();
        RenderWrapper.enableTexture();
    }

    public static void drawPolygon(PoseStack poseStack, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, ShapeProperties shapeProperties, int zoom) {
        float[] rgba;
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity() + 0.4f);
            RenderWrapper.setColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            int lastIndex = fillPoints.size() - 1;
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderWrapper.disableTexture();
            RenderWrapper.disableCull();
            RenderWrapper.setShader(GameRenderer::m_172811_);
            buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
            for (int i = 0; i <= lastIndex; ++i) {
                Point2D.Double point = fillPoints.get(i);
                DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), buffer, point.getX() + xOffset, point.getY() + yOffset, zLevel, rgba);
            }
            tessellator.m_85914_();
            RenderWrapper.enableCull();
            RenderWrapper.enableTexture();
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity() + 0.4f);
            RenderWrapper.setColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            float halfWidth = shapeProperties.getStrokeWidth() / 2.0f;
            for (List<Point2D.Double> screenPoints : strokePoints) {
                if (screenPoints.size() < 3) continue;
                int lastIndex = screenPoints.size() - 1;
                RenderWrapper.disableTexture();
                RenderWrapper.disableCull();
                RenderWrapper.setShader(GameRenderer::m_172811_);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                for (int i = 0; i <= lastIndex + 1; ++i) {
                    int iPoint = i <= lastIndex ? i : 0;
                    int iPrev = iPoint > 0 ? iPoint - 1 : lastIndex;
                    int iNext = iPoint < lastIndex ? iPoint + 1 : 0;
                    Point2D.Double point = screenPoints.get(iPoint);
                    Point2D.Double prev = screenPoints.get(iPrev);
                    Point2D.Double next = screenPoints.get(iNext);
                    Point2D.Double normal = DrawUtil.calculateNormal(prev, point, next);
                    DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), buffer, point.getX() + normal.getX() * (double)halfWidth + xOffset, point.getY() + normal.getY() * (double)halfWidth + yOffset, zLevel, rgba);
                    DrawUtil.addVertex(poseStack.m_85850_().m_252922_(), buffer, point.getX() - normal.getX() * (double)halfWidth + xOffset, point.getY() - normal.getY() * (double)halfWidth + yOffset, zLevel, rgba);
                }
                tesselator.m_85914_();
            }
            RenderWrapper.enableCull();
            RenderWrapper.enableTexture();
        }
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableTexture();
        RenderWrapper.disableBlend();
    }

    private static Point2D.Double calculateNormal(Point2D.Double prev, Point2D.Double point, Point2D.Double next) {
        Vec2 edgeNormal2;
        Vec2 edge1 = new Vec2((float)(point.x - prev.x), (float)(point.y - prev.y));
        Vec2 edge2 = new Vec2((float)(next.x - point.x), (float)(next.y - point.y));
        Vec2 edgeNormal1 = new Vec2(-edge1.f_82471_, edge1.f_82470_).m_165902_();
        Vec2 vertexNormal = edgeNormal1.m_165910_(edgeNormal2 = new Vec2(-edge2.f_82471_, edge2.f_82470_).m_165902_()).m_165902_();
        double angle = Math.acos(vertexNormal.m_165905_(edgeNormal1));
        double factor = Math.cos(angle);
        if (factor < 0.1) {
            factor = 0.1;
        }
        factor = 1.0 / factor;
        return new Point2D.Double((double)vertexNormal.f_82470_ * factor, (double)vertexNormal.f_82471_ * factor);
    }

    private static Point2D.Double calculateLineVector(Point2D.Double value, double xOffset, double yOffset) {
        double locX = value.x + xOffset;
        double locY = value.y + yOffset;
        boolean minimapDrawing = UIManager.INSTANCE.getMiniMap().isDrawing() && UIManager.INSTANCE.isMiniMapEnabled();
        double screenVecX = minimapDrawing ? UIManager.INSTANCE.getMiniMap().getDisplayVars().centerPoint.x : locX;
        double screenVecY = minimapDrawing ? UIManager.INSTANCE.getMiniMap().getDisplayVars().centerPoint.y : locY;
        return new Point2D.Double(screenVecX * 1.004, screenVecY * 1.004);
    }

    public static void drawGradientRect(PoseStack poseStack, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int[] rgbaStart = RGB.ints(startColor, startAlpha);
        int[] rgbaEnd = RGB.ints(endColor, endAlpha);
        RenderWrapper.disableTexture();
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        RenderWrapper.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        DrawUtil.addVertexUV(poseStack, buffer, x, height + y, zLevel, 0.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(poseStack, buffer, x + width, height + y, zLevel, 1.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(poseStack, buffer, x + width, y, zLevel, 1.0, 0.0, rgbaStart);
        DrawUtil.addVertexUV(poseStack, buffer, x, y, zLevel, 0.0, 0.0, rgbaStart);
        tessellator.m_85914_();
        RenderWrapper.enableTexture();
        RenderWrapper.enableBlend();
    }

    public static void drawBoundTexture(PoseStack poseStack, double startU, double startV, double startX, double startY, double z, double endU, double endV, double endX, double endY) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, startX, endY, z, startU, endV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, endX, endY, z, endU, endV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, endX, startY, z, endU, startV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, startX, startY, z, startU, startV);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void drawEntity(PoseStack poseStack, double x, double y, double heading, Texture texture, float scale, double rotation) {
        DrawUtil.drawEntity(poseStack, x, y, heading, texture, 1.0f, scale, rotation);
    }

    public static void drawEntity(PoseStack poseStack, double x, double y, double heading, Texture texture, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawImage(poseStack, texture, alpha, drawX, drawY, false, scale, heading);
    }

    public static void drawColoredEntity(PoseStack poseStack, double x, double y, Texture texture, int color, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawColoredImage(poseStack, texture, color, alpha, drawX, drawY, scale, rotation);
    }

    public static void sizeDisplay(PoseStack poseStack, double width, double height) {
        if (width > 0.0 && height > 0.0) {
            RenderWrapper.clear(256);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 100.0f, GuiHooks.getGuiFarPlane());
            RenderWrapper.setProjectionMatrix(matrix4f);
            PoseStack posestack = RenderWrapper.getModelViewStack();
            posestack.m_166856_();
            posestack.m_85837_(0.0, 0.0, (double)(1000.0f - GuiHooks.getGuiFarPlane()));
        }
    }

    public static void addVertexWithUV(PoseStack poseStack, BufferBuilder buff, float x, float y, float z, float u, float v) {
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        buff.m_252986_(matrix4f, x, y, z).m_7421_(u, v).m_5752_();
    }

    public static void addVertexWithUV(PoseStack poseStack, BufferBuilder buff, double x, double y, double z, double u, double v) {
        DrawUtil.addVertexWithUV(poseStack, buff, (float)x, (float)y, (float)z, (float)u, (float)v);
    }

    public static void addVertexUV(PoseStack poseStack, BufferBuilder buff, double x, double y, double z, double u, double v, int[] rgba) {
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        buff.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_6122_(rgba[0], rgba[1], rgba[2], rgba[3]).m_7421_((float)u, (float)v).m_5752_();
    }

    private static void addVertex(Matrix4f mat, BufferBuilder buff, double x, double y, double z, int[] rgba) {
        buff.m_252986_(mat, (float)x, (float)y, (float)z).m_6122_(rgba[0], rgba[1], rgba[2], rgba[3]).m_5752_();
    }

    private static void addVertex(Matrix4f mat, BufferBuilder buff, double x, double y, double z, float[] rgba) {
        buff.m_252986_(mat, (float)x, (float)y, (float)z).m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]).m_5752_();
    }

    private static void addVertexNormal(Matrix4f mat, BufferBuilder buff, double x, double y, double z, float pX, float pY, float pZ, float[] rgba) {
        buff.m_252986_(mat, (float)x, (float)y, (float)z).m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]).m_5601_(pX, pY, pZ).m_5752_();
    }

    private static void addVertexNormal3f(Matrix4f mat, Matrix3f normal, BufferBuilder buff, double x, double y, double z, float pX, float pY, float pZ, float[] rgba) {
        buff.m_252986_(mat, (float)x, (float)y, (float)z).m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]).m_252939_(normal, pX, pY, pZ).m_5752_();
    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }
}

