/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers_old.common.registry;

import com.folumo.mekanism_lasers_old.common.block.Laser;
import com.folumo.mekanism_lasers_old.common.block.LaserStopper;
import com.folumo.mekanism_lasers_old.common.block.OreGenerator;
import com.folumo.mekanism_lasers_old.common.block.ToggleableLaser;
import com.folumo.mekanism_lasers_old.common.block_entity.LaserBlockEntity;
import com.folumo.mekanism_lasers_old.common.block_entity.LaserStopperBlockEntity;
import com.folumo.mekanism_lasers_old.common.block_entity.OreGeneratorBlockEntity;
import com.folumo.mekanism_lasers_old.common.block_entity.ToggleableLaserBlockEntity;
import com.folumo.mekanism_lasers_old.common.item.LaserBlockItem;
import com.folumo.mekanism_lasers_old.common.item.LaserStopperBlockItem;
import com.folumo.mekanism_lasers_old.common.item.OreGeneratorBlockItem;
import com.folumo.mekanism_lasers_old.common.item.ToggleableLaserBlockItem;
import com.folumo.mekanism_lasers_old.common.registry.BlockTypeRegistry;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;

public class BlockRegistry {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanism_lasers");
    public static final BlockRegistryObject<LaserStopper, LaserStopperBlockItem> LASER_STOPPER = BLOCKS.register("laser_stopper", () -> new LaserStopper(BlockTypeRegistry.LASER_STOPPER), block -> new LaserStopperBlockItem((BlockTile.BlockTileModel<LaserStopperBlockEntity, BlockTypeTile<LaserStopperBlockEntity>>)block, new Item.Properties().m_41497_(Rarity.UNCOMMON)));
    public static final BlockRegistryObject<Laser, LaserBlockItem> BASIC_LASER = BlockRegistry.registerLaser(BlockTypeRegistry.BASIC_LASER);
    public static final BlockRegistryObject<Laser, LaserBlockItem> ADVANCED_LASER = BlockRegistry.registerLaser(BlockTypeRegistry.ADVANCED_LASER);
    public static final BlockRegistryObject<Laser, LaserBlockItem> ELITE_LASER = BlockRegistry.registerLaser(BlockTypeRegistry.ELITE_LASER);
    public static final BlockRegistryObject<Laser, LaserBlockItem> ULTIMATE_LASER = BlockRegistry.registerLaser(BlockTypeRegistry.ULTIMATE_LASER);
    public static final BlockRegistryObject<Laser, LaserBlockItem> CREATIVE_LASER = BlockRegistry.registerLaser(BlockTypeRegistry.CREATIVE_LASER);
    public static final BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> BASIC_TOGGLEABLE_LASER = BlockRegistry.registerToggleableLaser(BlockTypeRegistry.BASIC_TOGGLEABLE_LASER);
    public static final BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> ADVANCED_TOGGLEABLE_LASER = BlockRegistry.registerToggleableLaser(BlockTypeRegistry.ADVANCED_TOGGLEABLE_LASER);
    public static final BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> ELITE_TOGGLEABLE_LASER = BlockRegistry.registerToggleableLaser(BlockTypeRegistry.ELITE_TOGGLEABLE_LASER);
    public static final BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> ULTIMATE_TOGGLEABLE_LASER = BlockRegistry.registerToggleableLaser(BlockTypeRegistry.ULTIMATE_TOGGLEABLE_LASER);
    public static final BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> CREATIVE_TOGGLEABLE_LASER = BlockRegistry.registerToggleableLaser(BlockTypeRegistry.CREATIVE_TOGGLEABLE_LASER);
    public static final BlockRegistryObject<OreGenerator, OreGeneratorBlockItem> ORE_GENERATOR = BLOCKS.register("ore_generator", () -> new OreGenerator(BlockTypeRegistry.ORE_GENERATOR), block -> new OreGeneratorBlockItem((BlockTile.BlockTileModel<OreGeneratorBlockEntity, BlockTypeTile<OreGeneratorBlockEntity>>)block, new Item.Properties().m_41497_(Rarity.UNCOMMON)));

    private static BlockRegistryObject<Laser, LaserBlockItem> registerLaser(BlockTypeTile<LaserBlockEntity> type) {
        return BlockRegistry.registerTieredBlock(type, "_laser", () -> new Laser(type), LaserBlockItem::new);
    }

    private static BlockRegistryObject<ToggleableLaser, ToggleableLaserBlockItem> registerToggleableLaser(BlockTypeTile<ToggleableLaserBlockEntity> type) {
        return BlockRegistry.registerTieredBlock(type, "_toggleable_laser", () -> new ToggleableLaser(type), ToggleableLaserBlockItem::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return BlockRegistry.registerTieredBlock(((AttributeTier)type.get(AttributeTier.class)).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }
}

