/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.system.core;

import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.AnimationHandler;
import andrews.table_top_craft.animation.system.core.KeyframeGroup;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.AnimationState;

public class AdvancedAnimationState
extends AnimationState {
    public Map<KeyframeGroup, Integer> cachedIndex = Maps.newHashMap();
    private final AtomicReference<Animation> animation;
    private float easeInTime = 0.0f;
    private float easeOutTime = 0.0f;
    private float prevElapsedTime = 0.0f;
    private boolean keepEasingIn = true;
    private EasingTypes easeInType = null;
    private EasingTypes easeOutType = null;
    private boolean forceInLinear = false;
    private boolean forceOutLinear = false;

    public AdvancedAnimationState(AtomicReference<Animation> animation) {
        this.animation = animation;
    }

    public AdvancedAnimationState(AdvancedAnimationState state) {
        this.f_216970_ = state.f_216970_;
        this.f_216971_ = state.f_216971_;
        this.cachedIndex.putAll(state.cachedIndex);
        this.animation = new AtomicReference<Animation>(state.getAnimation());
        this.easeInTime = state.getInTime();
        this.easeOutTime = state.getOutTime();
        this.prevElapsedTime = state.getPrevElapsedTime();
        this.keepEasingIn = state.keepEasingIn();
        this.easeInType = state.getEaseInType();
        this.easeOutType = state.getEaseOutType();
        this.forceInLinear = state.forceInLinear();
        this.forceOutLinear = state.forceOutLinear();
    }

    public Animation getAnimation() {
        return this.animation.get();
    }

    public void setAnimation(Animation animation) {
        this.animation.set(animation);
    }

    public void m_216973_() {
        super.m_216973_();
        this.cachedIndex.clear();
        this.easeInTime = 0.0f;
        this.easeOutTime = 0.0f;
        this.prevElapsedTime = 0.0f;
    }

    public float getInTime() {
        return this.easeInTime;
    }

    public void resetInTime() {
        this.easeInTime = 0.0f;
    }

    public float getOutTime() {
        return this.easeOutTime;
    }

    public boolean keepEasingIn() {
        return this.keepEasingIn;
    }

    public EasingTypes getEaseInType() {
        return this.easeInType;
    }

    public EasingTypes getEaseOutType() {
        return this.easeOutType;
    }

    public boolean forceInLinear() {
        return this.forceInLinear;
    }

    public boolean forceOutLinear() {
        return this.forceOutLinear;
    }

    public void interpolateAndStart(float easeInTime, EasingTypes easeInType, boolean forceInLinear, int ageInTicks) {
        this.interpolateAndStart(easeInTime, easeInType, forceInLinear, ageInTicks, true);
    }

    public void interpolateAndStart(float easeInTime, EasingTypes easeInType, boolean forceInLinear, int ageInTicks, boolean keepEasingIn) {
        this.keepEasingIn = keepEasingIn;
        this.easeInTime = easeInTime;
        this.easeInType = easeInType;
        this.forceInLinear = forceInLinear;
        this.m_216982_(ageInTicks);
    }

    public void interpolateAndStop(float easeOutTime, EasingTypes easeOutType, boolean forceOutLinear) {
        if (this.getAnimation() != null && this.m_216984_()) {
            this.easeOutType = easeOutType;
            this.forceOutLinear = forceOutLinear;
            float elapsedSeconds = AnimationHandler.getElapsedSeconds(this);
            if (this.getInTime() != 0.0f && elapsedSeconds < this.getInTime() && easeOutTime >= this.getInTime()) {
                easeOutTime = elapsedSeconds;
            }
            this.prevElapsedTime = elapsedSeconds;
            this.easeOutTime = easeOutTime;
        }
    }

    public float getPrevElapsedTime() {
        return this.prevElapsedTime;
    }

    public boolean isFinished() {
        if (this.getAnimation() == null) {
            return false;
        }
        if (this.getAnimation().isLooping() || this.getAnimation().getLengthInSeconds() == 0.0f) {
            return false;
        }
        return AnimationHandler.getElapsedSeconds(this) > this.getAnimation().getLengthInSeconds() + this.easeInTime + this.easeOutTime;
    }
}

