/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player.ai;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.ai.BoardEvaluator;
import andrews.table_top_craft.game_logic.chess.player.ai.PawnStructureAnalyzer;
import net.minecraft.network.chat.Component;

public final class StandardBoardEvaluator
implements BoardEvaluator {
    private static final int CHECK_BONUS = 50;
    private static final int CHECK_MATE_BONUS = 10000;
    private static final int DEPTH_BONUS = 100;
    private static final int CASTLE_BONUS = 60;
    private static final int TWO_BISHOPS_BONUS = 25;
    private static final StandardBoardEvaluator INSTANCE = new StandardBoardEvaluator();

    public static StandardBoardEvaluator get() {
        return INSTANCE;
    }

    @Override
    public int evaluate(Board board, int depth) {
        return this.scorePlayer(board, board.getWhiteChessPlayer(), depth) - this.scorePlayer(board, board.getBlackChessPlayer(), depth);
    }

    public String evaluationDetails(Board board, int depth) {
        String whiteMobility = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.mobility", (Object[])new Object[]{this.mobility(board.getWhiteChessPlayer())}).getString();
        String whiteKingThreats = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.king_threats", (Object[])new Object[]{StandardBoardEvaluator.kingThreats(board.getWhiteChessPlayer(), depth)}).getString();
        String whitePossibleAttacks = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.possible_attacks", (Object[])new Object[]{StandardBoardEvaluator.attacks(board.getWhiteChessPlayer())}).getString();
        String whiteCastled = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.castled", (Object[])new Object[]{StandardBoardEvaluator.castle(board.getWhiteChessPlayer())}).getString();
        String whitePieceValue = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.piece_value", (Object[])new Object[]{StandardBoardEvaluator.pieceEvaluations(board.getWhiteChessPlayer())}).getString();
        String whitePawnStructure = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.white.pawn_structure", (Object[])new Object[]{StandardBoardEvaluator.pawnStructure(board.getWhiteChessPlayer())}).getString();
        String blackMobility = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.mobility", (Object[])new Object[]{this.mobility(board.getBlackChessPlayer())}).getString();
        String blackKingThreats = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.king_threats", (Object[])new Object[]{StandardBoardEvaluator.kingThreats(board.getBlackChessPlayer(), depth)}).getString();
        String blackPossibleAttacks = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.possible_attacks", (Object[])new Object[]{StandardBoardEvaluator.attacks(board.getBlackChessPlayer())}).getString();
        String blackCastled = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.castled", (Object[])new Object[]{StandardBoardEvaluator.castle(board.getBlackChessPlayer())}).getString();
        String blackPieceValue = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.piece_value", (Object[])new Object[]{StandardBoardEvaluator.pieceEvaluations(board.getBlackChessPlayer())}).getString();
        String blackPawnStructure = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.black.pawn_structure", (Object[])new Object[]{StandardBoardEvaluator.pawnStructure(board.getBlackChessPlayer())}).getString();
        String finalScore = Component.m_237110_((String)"gui.table_top_craft.chess.evaluation.final_score", (Object[])new Object[]{this.evaluate(board, depth)}).getString();
        return whiteMobility + "\n" + whiteKingThreats + "\n" + whitePossibleAttacks + "\n" + whiteCastled + "\n" + whitePieceValue + "\n" + whitePawnStructure + "\n\n" + blackMobility + "\n" + blackKingThreats + "\n" + blackPossibleAttacks + "\n" + blackCastled + "\n" + blackPieceValue + "\n" + blackPawnStructure + "\n\n" + finalScore;
    }

    private static int kingThreats(BaseChessPlayer player, int depth) {
        return player.getOpponent().isInCheckMate() ? 10000 * StandardBoardEvaluator.depthBonus(depth) : StandardBoardEvaluator.check(player);
    }

    private static int attacks(BaseChessPlayer player) {
        int attackScore = 0;
        for (BaseMove move : player.getLegalMoves()) {
            if (!move.isAttack()) continue;
            BasePiece movedPiece = move.getMovedPiece();
            BasePiece attackedPiece = move.getAttackedPiece();
            if (movedPiece.getPieceValue() > attackedPiece.getPieceValue()) continue;
            ++attackScore;
        }
        return attackScore;
    }

    private static int castle(BaseChessPlayer player) {
        return player.isCastled() ? 60 : 0;
    }

    private static int pieceEvaluations(BaseChessPlayer player) {
        int pieceValuationScore = 0;
        int numBishops = 0;
        for (BasePiece piece : player.getActivePieces()) {
            pieceValuationScore += piece.getPieceValue() + piece.locationBonus();
            if (piece.getPieceType() != BasePiece.PieceType.BISHOP) continue;
            ++numBishops;
        }
        return pieceValuationScore + (numBishops == 2 ? 25 : 0);
    }

    private static int pawnStructure(BaseChessPlayer player) {
        return PawnStructureAnalyzer.pawnStructureScore(player);
    }

    private int scorePlayer(Board board, BaseChessPlayer player, int depth) {
        return StandardBoardEvaluator.pieceValue(player) + this.mobility(player) + StandardBoardEvaluator.check(player) + StandardBoardEvaluator.checkMate(player, depth) + StandardBoardEvaluator.castled(player);
    }

    private static int castled(BaseChessPlayer player) {
        return player.isCastled() ? 60 : 0;
    }

    private static int checkMate(BaseChessPlayer player, int depth) {
        return player.getOpponent().isInCheckMate() ? 10000 * StandardBoardEvaluator.depthBonus(depth) : 0;
    }

    private static int depthBonus(int depth) {
        return depth == 0 ? 1 : 100 * depth;
    }

    private static int check(BaseChessPlayer player) {
        return player.getOpponent().isInCheck() ? 50 : 0;
    }

    private int mobility(BaseChessPlayer player) {
        return player.getLegalMoves().size();
    }

    private static int pieceValue(BaseChessPlayer player) {
        int pieceValueScore = 0;
        for (BasePiece piece : player.getActivePieces()) {
            pieceValueScore += piece.getPieceValue();
        }
        return pieceValueScore;
    }
}

