/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessTimerBlockEntity;
import andrews.table_top_craft.screens.chess_timer.buttons.ChessTimerTimeAlteringButton;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerAdjustChessTimerTime {
    private final BlockPos pos;
    private final byte type;
    private final byte category;

    public MessageServerAdjustChessTimerTime(BlockPos pos, byte type, byte category) {
        this.pos = pos;
        this.type = type;
        this.category = category;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.type);
        buf.writeByte((int)this.category);
    }

    public static MessageServerAdjustChessTimerTime deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte type = buf.readByte();
        byte category = buf.readByte();
        return new MessageServerAdjustChessTimerTime(pos, type, category);
    }

    public static void handle(MessageServerAdjustChessTimerTime message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        ChessTimerTimeAlteringButton.TimeModifierType type = Arrays.stream(ChessTimerTimeAlteringButton.TimeModifierType.values()).filter(e -> e.getIdx() == message.type).findFirst().orElse(null);
        ChessTimerTimeAlteringButton.TimeCategory category = Arrays.stream(ChessTimerTimeAlteringButton.TimeCategory.values()).filter(e -> e.getIdx() == message.category).findFirst().orElse(null);
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerAdjustChessTimerTime.lambda$handle$2((Player)player, type, category, pos));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$2(Player player, ChessTimerTimeAlteringButton.TimeModifierType type, ChessTimerTimeAlteringButton.TimeCategory category, BlockPos pos) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && type != null && category != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ChessTimerBlockEntity) {
            ChessTimerBlockEntity chessTimerBlockEntity = (ChessTimerBlockEntity)blockEntity;
            if (category.getIdx() < 3) {
                chessTimerBlockEntity.modifyLeftTimer((long)type.getModifier() * category.getMillis());
            } else {
                chessTimerBlockEntity.modifyRightTimer((long)type.getModifier() * category.getMillis());
            }
            chessTimerBlockEntity.lastSwitchTime = 0L;
            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
            level.m_46672_(pos, level.m_8055_(pos).m_60734_());
            chessTimerBlockEntity.m_6596_();
        }
    }
}

