/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerChangePieceSet {
    private final BlockPos pos;
    private final byte value;

    public MessageServerChangePieceSet(BlockPos pos, byte value) {
        this.pos = pos;
        this.value = value;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.value);
    }

    public static MessageServerChangePieceSet deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte value = buf.readByte();
        return new MessageServerChangePieceSet(pos, value);
    }

    public static void handle(MessageServerChangePieceSet message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos blockPos = message.pos;
        byte value = message.value;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerChangePieceSet.lambda$handle$0((Player)player, blockPos, value, message));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos blockPos, byte value, MessageServerChangePieceSet message) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(blockPos)) instanceof ChessPieceFigureBlockEntity) {
            ChessPieceFigureBlockEntity chessPieceFigureBlockEntity = (ChessPieceFigureBlockEntity)blockEntity;
            int currentSet = chessPieceFigureBlockEntity.getPieceSet();
            if (value > 0) {
                if (currentSet < 3) {
                    chessPieceFigureBlockEntity.setPieceSet(++currentSet);
                } else {
                    chessPieceFigureBlockEntity.setPieceSet(1);
                }
            } else if (value < 0) {
                if (currentSet > 1) {
                    chessPieceFigureBlockEntity.setPieceSet(--currentSet);
                } else {
                    chessPieceFigureBlockEntity.setPieceSet(3);
                }
            }
            level.m_7260_(message.pos, level.m_8055_(blockPos), level.m_8055_(blockPos), 2);
            chessPieceFigureBlockEntity.m_6596_();
        }
    }
}

