/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSetPieceSet {
    private final BlockPos pos;
    private final int pieceSet;

    public MessageServerSetPieceSet(BlockPos pos, int pieceSet) {
        this.pos = pos;
        this.pieceSet = pieceSet;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.pieceSet);
    }

    public static MessageServerSetPieceSet deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int pieceSet = buf.readInt();
        return new MessageServerSetPieceSet(pos, pieceSet);
    }

    public static void handle(MessageServerSetPieceSet message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos chessPos = message.pos;
        int pieceSet = message.pieceSet;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerSetPieceSet.lambda$handle$0((Player)player, chessPos, pieceSet, message));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos chessPos, int pieceSet, MessageServerSetPieceSet message) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(chessPos)) instanceof ChessBlockEntity) {
            ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
            switch (pieceSet) {
                case 0: {
                    chessBlockEntity.setPieceSet(0);
                    break;
                }
                case 1: {
                    chessBlockEntity.setPieceSet(1);
                    break;
                }
                case 2: {
                    chessBlockEntity.setPieceSet(2);
                }
            }
            level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
            chessBlockEntity.m_6596_();
            NetworkUtil.setChessAnimationForAllTracking(level, chessPos, (byte)1);
        }
    }
}

