/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.buttons.pieces;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.util.NetworkUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ChessBoardPawnPromotionButton
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/buttons/chess_pawn_promotion_buttons.png");
    private static final Component QUEEN_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.queen");
    private static final Component BISHOP_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.bishop");
    private static final Component KNIGHT_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.knight");
    private static final Component ROOK_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.rook");
    private final ItemStack chessPieceFigure = new ItemStack((ItemLike)TTCBlocks.CHESS_PIECE_FIGURE.get());
    private final ChessBlockEntity blockEntity;
    private final PawnPromotionPieceType type;

    public ChessBoardPawnPromotionButton(ChessBlockEntity blockEntity, int pX, int pY, boolean isWhite, PawnPromotionPieceType type) {
        super(pX, pY, 43, 43, (Component)Component.m_237113_((String)""));
        this.blockEntity = blockEntity;
        this.type = type;
        ChessPieceFigureBlockEntity previewBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        previewBlockEntity.setPieceSet(blockEntity.getPieceSet() + 1);
        previewBlockEntity.setPieceType(type.getPieceType());
        previewBlockEntity.setPieceColor(isWhite ? blockEntity.getWhitePiecesColor() : blockEntity.getBlackPiecesColor());
        previewBlockEntity.setRotateChessPieceFigure(false);
        previewBlockEntity.m_187476_(this.chessPieceFigure);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(TEXTURE, this.f_93620_, this.f_93621_, this.m_198029_() ? 43 : 0, 0, 43, 43);
        this.renderChessPiece(graphics.m_280168_(), this.chessPieceFigure, this.f_93620_ + 21, this.f_93621_ + 21 - 3, 40);
        if (Minecraft.m_91087_().f_91080_ != null && this.m_198029_()) {
            int posX = this.m_274382_() ? mouseX : this.f_93620_ - 8;
            int posY = this.m_274382_() ? mouseY : this.f_93621_;
            graphics.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            switch (this.type) {
                default: {
                    graphics.m_280557_(Minecraft.m_91087_().f_91062_, QUEEN_TXT, posX, posY);
                    break;
                }
                case BISHOP: {
                    graphics.m_280557_(Minecraft.m_91087_().f_91062_, BISHOP_TXT, posX, posY);
                    break;
                }
                case KNIGHT: {
                    graphics.m_280557_(Minecraft.m_91087_().f_91062_, KNIGHT_TXT, posX, posY);
                    break;
                }
                case ROOK: {
                    graphics.m_280557_(Minecraft.m_91087_().f_91062_, ROOK_TXT, posX, posY);
                }
            }
            RenderSystem.enableDepthTest();
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)pX, (float)pY, 100.0f);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public void m_5691_() {
        NetworkUtil.doPawnPromotion(this.blockEntity.m_58899_(), (byte)this.type.getPieceType());
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }

    public static enum PawnPromotionPieceType {
        QUEEN(6),
        BISHOP(3),
        KNIGHT(4),
        ROOK(2);

        final int pieceType;

        private PawnPromotionPieceType(int pieceType) {
            this.pieceType = pieceType;
        }

        public int getPieceType() {
            return this.pieceType;
        }
    }
}

