/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus.color_selection;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessConfirmColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessRandomColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessResetColorButton;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.IColorPickerExtended;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessBoardTilesColorScreen
extends BaseScreen
implements IColorPicker,
IColorPickerExtended {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final ResourceLocation PREVIEW_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/preview_color.png");
    private static final ResourceLocation PREVIEW_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/medium_chess_menu.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.table_top_craft.chess.color.tiles");
    private static final Component PREVIEW_COLOR_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.color.colors_preview");
    private static final Component WHITE_PREVIEW_COLOR_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.color.white_tiles_settings");
    private static final Component BLACK_PREVIEW_COLOR_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.color.black_tiles_settings");
    private final ChessBlockEntity chessBlockEntity;
    private final boolean isColorPickerActive;
    private final boolean isOptionalColorPickerActive;
    private ChessRedColorSlider whiteRedColorSlider;
    private ChessGreenColorSlider whiteGreenColorSlider;
    private ChessBlueColorSlider whiteBlueColorSlider;
    private ChessRedColorSlider blackRedColorSlider;
    private ChessGreenColorSlider blackGreenColorSlider;
    private ChessBlueColorSlider blackBlueColorSlider;
    private TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;

    public ChessBoardTilesColorScreen(ChessBlockEntity chessBlockEntity, boolean isColorPickerActive, boolean isOptionalColorPickerActive) {
        super(TEXTURE, 177, 198, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.isColorPickerActive = isColorPickerActive;
        this.isOptionalColorPickerActive = isOptionalColorPickerActive;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessBlockEntity, this, false, this.x + 68, this.y + 54));
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessBlockEntity, this, true, this.x + 153, this.y + 54));
        this.whiteRedColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 92, 167, 12, NBTColorSaving.getRed(this.chessBlockEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteRedColorSlider);
        this.whiteGreenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 105, 167, 12, NBTColorSaving.getGreen(this.chessBlockEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteGreenColorSlider);
        this.whiteBlueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 118, 167, 12, NBTColorSaving.getBlue(this.chessBlockEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteBlueColorSlider);
        this.blackRedColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 141, 167, 12, NBTColorSaving.getRed(this.chessBlockEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackRedColorSlider);
        this.blackGreenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 154, 167, 12, NBTColorSaving.getGreen(this.chessBlockEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackGreenColorSlider);
        this.blackBlueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 167, 167, 12, NBTColorSaving.getBlue(this.chessBlockEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackBlueColorSlider);
        this.m_142416_((GuiEventListener)new ChessRandomColorButton(this, this.x + 5, this.y + 68));
        this.m_142416_((GuiEventListener)new ChessResetColorButton(ChessResetColorButton.DefaultColorType.BOARD_TILES, this, this.x + 90, this.y + 68));
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessBlockEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_COLORS, ChessCancelButton.ChessCancelButtonText.CANCEL, this.x + 5, this.y + 180));
        this.m_142416_((GuiEventListener)new ChessConfirmColorButton(ChessConfirmColorButton.ColorMenuType.BOARD_PLATE, this.chessBlockEntity, this.whiteRedColorSlider, this.blackRedColorSlider, this.whiteGreenColorSlider, this.blackGreenColorSlider, this.whiteBlueColorSlider, this.blackBlueColorSlider, this.x + 90, this.y + 180));
        if (this.isColorPickerActive) {
            Color color = new Color(this.whiteRedColorSlider.getValueInt(), this.whiteGreenColorSlider.getValueInt(), this.whiteBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 158, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        } else if (this.isOptionalColorPickerActive) {
            Color color = new Color(this.blackRedColorSlider.getValueInt(), this.blackGreenColorSlider.getValueInt(), this.blackBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 158, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
    }

    @Override
    public void renderScreenContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isColorPickerActive || this.isOptionalColorPickerActive) {
            graphics.m_280218_(COLOR_PICKER_FRAME_TEXTURE, this.x - 136, this.y + 23, 0, 0, 136, 151);
        }
        graphics.m_280218_(PREVIEW_FRAME_TEXTURE, this.x + 25, this.y + 25, 0, 131, 42, 42);
        graphics.m_280218_(PREVIEW_FRAME_TEXTURE, this.x + 110, this.y + 25, 0, 131, 42, 42);
        graphics.m_280168_().m_85836_();
        graphics.m_280246_(0.003921569f * (float)this.whiteRedColorSlider.getValueInt(), 0.003921569f * (float)this.whiteGreenColorSlider.getValueInt(), 0.003921569f * (float)this.whiteBlueColorSlider.getValueInt(), 1.0f);
        graphics.m_280168_().m_252880_((float)(this.x + 26), (float)(this.y + 26), 0.0f);
        graphics.m_280168_().m_85841_(2.5f, 2.5f, 2.5f);
        graphics.m_280218_(PREVIEW_TEXTURE, 0, 0, 0, 0, 16, 16);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280246_(0.003921569f * (float)this.blackRedColorSlider.getValueInt(), 0.003921569f * (float)this.blackGreenColorSlider.getValueInt(), 0.003921569f * (float)this.blackBlueColorSlider.getValueInt(), 1.0f);
        graphics.m_280168_().m_252880_((float)(this.x + 111), (float)(this.y + 26), 0.0f);
        graphics.m_280168_().m_85841_(2.5f, 2.5f, 2.5f);
        graphics.m_280218_(PREVIEW_TEXTURE, 0, 0, 0, 0, 16, 16);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
        this.drawCenteredString(TITLE, this.f_96543_ / 2 + (this.isColorPickerActive || this.isOptionalColorPickerActive ? 68 : 0), this.y + 6, 0x404040, false, graphics);
        graphics.m_280614_(this.f_96547_, PREVIEW_COLOR_TXT, this.x + 88 - this.f_96547_.m_92852_((FormattedText)PREVIEW_COLOR_TXT) / 2, this.y + 16, 0, false);
        graphics.m_280614_(this.f_96547_, WHITE_PREVIEW_COLOR_TXT, this.x + 5, this.y + 83, 0, false);
        graphics.m_280614_(this.f_96547_, BLACK_PREVIEW_COLOR_TXT, this.x + 5, this.y + 132, 0, false);
    }

    @Override
    public int offsetX() {
        return this.isColorPickerActive || this.isOptionalColorPickerActive ? 136 : super.offsetX();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.whiteRedColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.whiteGreenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.whiteBlueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }

    @Override
    public ForgeSlider getOptionalRedSlider() {
        return this.blackRedColorSlider;
    }

    @Override
    public ForgeSlider getOptionalGreenSlider() {
        return this.blackGreenColorSlider;
    }

    @Override
    public ForgeSlider getOptionalBlueSlider() {
        return this.blackBlueColorSlider;
    }

    @Override
    public boolean isOptionalColorPickerActive() {
        return this.isOptionalColorPickerActive;
    }
}

