/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util.loot_table;

import andrews.table_top_craft.util.loot_table.IGetPools;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="table_top_craft")
public class TTCLootTableHandler {
    public static final Set<ResourceLocation> JUNGLE_TEMPLE_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78686_});
    public static final Set<ResourceLocation> DESERT_PYRAMID_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78764_});
    public static final Set<ResourceLocation> ABANDONED_MINESHAFT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78759_});
    public static final Set<ResourceLocation> SIMPLE_DUNGEON_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78742_});
    public static final Set<ResourceLocation> NETHER_BRIDGE_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78760_});

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        if (JUNGLE_TEMPLE_INJECTIONS.contains(event.getName())) {
            TTCLootTableHandler.addPool(event.getTable(), LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("table_top_craft", "injections/chess_piece_jungle_temple"))).m_79082_());
        }
        if (DESERT_PYRAMID_INJECTIONS.contains(event.getName())) {
            TTCLootTableHandler.addPool(event.getTable(), LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("table_top_craft", "injections/chess_piece_desert_pyramid"))).m_79082_());
        }
        if (ABANDONED_MINESHAFT_INJECTIONS.contains(event.getName())) {
            TTCLootTableHandler.addPool(event.getTable(), LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("table_top_craft", "injections/chess_piece_abandoned_mineshaft"))).m_79082_());
        }
        if (SIMPLE_DUNGEON_INJECTIONS.contains(event.getName())) {
            TTCLootTableHandler.addPool(event.getTable(), LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("table_top_craft", "injections/chess_piece_simple_dungeon"))).m_79082_());
        }
        if (NETHER_BRIDGE_INJECTIONS.contains(event.getName())) {
            TTCLootTableHandler.addPool(event.getTable(), LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("table_top_craft", "injections/chess_piece_nether_bridge"))).m_79082_());
        }
    }

    @Deprecated
    public static void addPool(LootTable table, LootPool pool) {
        if (table instanceof IGetPools) {
            IGetPools accessiblePoolsTable = (IGetPools)table;
            if (table.isFrozen()) {
                throw new RuntimeException("Attempted to modify LootTable after being finalized!");
            }
            accessiblePoolsTable.getPools().add(pool);
        }
    }
}

