/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.ContainerBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ContainerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");

    public ContainerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (pLevel.f_46443_ || ((Boolean)pState.m_61143_((Property)OPENED)).booleanValue() || !((blockEntity = pLevel.m_7702_(pPos)) instanceof ContainerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ContainerBlockEntity containerBlockEntity = (ContainerBlockEntity)blockEntity;
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (!stack.m_204117_(ModTags.Items.CROWBAR)) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.container.fail.crowbar"), true);
            return InteractionResult.PASS;
        }
        if (!this.hasEntity(pLevel, pPos)) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.container.fail.empty"), true);
            return InteractionResult.PASS;
        }
        if (ContainerBlock.canOpen(pLevel, pPos, containerBlockEntity.entityType, containerBlockEntity.entityTag)) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(true)));
            pLevel.m_5594_(null, BlockPos.m_274561_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), (SoundEvent)ModSounds.OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.container.fail.open"), true);
        return InteractionResult.PASS;
    }

    public boolean hasEntity(Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof ContainerBlockEntity)) {
            return false;
        }
        ContainerBlockEntity containerBlockEntity = (ContainerBlockEntity)blockEntity;
        return containerBlockEntity.entityTag != null || containerBlockEntity.entityType != null;
    }

    public static boolean canOpen(Level pLevel, BlockPos pPos, EntityType<?> entityType, CompoundTag tag) {
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_(pLevel);
        if (entity != null && tag != null) {
            entity.m_20258_(tag);
        }
        boolean flag = true;
        int w = (int)(entityType.m_20680_().f_20377_ / 2.0f + 1.0f);
        int h = (int)(entityType.m_20680_().f_20378_ + 1.0f);
        if (entity != null) {
            w = (int)(entity.m_6095_().m_20680_().f_20377_ / 2.0f + 1.0f);
            h = (int)(entity.m_6095_().m_20680_().f_20378_ + 1.0f);
        }
        for (int i = -w; i < w + 1; ++i) {
            for (int j = 0; j < h; ++j) {
                for (int k = -w; k < w + 1; ++k) {
                    BlockState state;
                    if (i == 0 && j == 0 && k == 0 || !(state = pLevel.m_8055_(pPos.m_7918_(i, j, k))).m_60815_() || state.m_60713_(Blocks.f_50125_)) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_) {
            return ContainerBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CONTAINER.get()), ContainerBlockEntity::serverTick);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        block8: {
            super.m_5871_(pStack, pLevel, pTooltip, pFlag);
            tag = BlockItem.m_186336_((ItemStack)pStack);
            if (tag == null || !tag.m_128441_("EntityType")) break block8;
            type = tag.m_128461_("EntityType");
            location = ResourceLocation.m_135820_((String)type);
            if (location == null) {
                return;
            }
            info = Component.m_264568_((String)("info." + location.m_135827_() + "." + location.m_135815_()), (String)"");
            v0 = hasDescription = info.getString().isEmpty() == false;
            if (Screen.m_96638_() && hasDescription) {
                pTooltip.add((Component)info.m_130940_(ChatFormatting.GRAY));
                pTooltip.add((Component)Component.m_237119_());
                pTooltip.add((Component)Component.m_264568_((String)("info." + location.m_135827_() + ".mod_id"), (String)location.m_135827_()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.AQUA));
            } else {
                entityTranslationKey = ContainerBlock.getEntityTranslationKey(type);
                pTooltip.add((Component)Component.m_237115_((String)(entityTranslationKey == null ? "des.superbwarfare.container.empty" : entityTranslationKey)).m_130940_(ChatFormatting.GRAY));
            }
            entityType = EntityType.m_20632_((String)type).orElse(null);
            if (entityType == null) break block8;
            w = 0.0f;
            h = 0;
            if (!(pLevel instanceof Level)) ** GOTO lbl-1000
            level = (Level)pLevel;
            if (tag.m_128441_("Entity")) {
                entity = entityType.m_20615_(level);
                if (entity != null) {
                    entity.m_20258_(tag.m_128469_("Entity"));
                    w = (float)Math.ceil(entity.m_6095_().m_20680_().f_20377_ / 2.0f);
                    h = (int)(entity.m_6095_().m_20680_().f_20378_ + 1.0f);
                }
            } else lbl-1000:
            // 2 sources

            {
                w = (float)Math.ceil(entityType.m_20680_().f_20377_ / 2.0f);
                h = (int)(entityType.m_20680_().f_20378_ + 1.0f);
            }
            if (w != 0.0f && h != 0) {
                if ((int)(w *= 2.0f) % 2 == 0) {
                    w += 1.0f;
                }
                pTooltip.add((Component)Component.m_237113_((String)((int)w + " x " + (int)w + " x " + h)).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    @Nullable
    public static String getEntityTranslationKey(String path) {
        String[] parts = path.split(":");
        if (parts.length > 1) {
            return "entity." + parts[0] + "." + parts[1];
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPENED) != false ? ContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0) : ContainerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ContainerBlockEntity(blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{OPENED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemstack = super.m_7397_(pLevel, pPos, pState);
        pLevel.m_141902_(pPos, (BlockEntityType)ModBlockEntities.CONTAINER.get()).ifPresent(blockEntity -> blockEntity.m_187476_(itemstack));
        return itemstack;
    }
}

