/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.ChargingStationBlock;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.menu.ChargingStationMenu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    protected static final int SLOT_FUEL = 0;
    protected static final int SLOT_CHARGE = 1;
    public static final int MAX_DATA_COUNT = 4;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    public static final int MAX_ENERGY = (Integer)MiscConfig.CHARGING_STATION_MAX_ENERGY.get();
    public static final int DEFAULT_FUEL_TIME = (Integer)MiscConfig.CHARGING_STATION_DEFAULT_FUEL_TIME.get();
    public static final int CHARGE_SPEED = (Integer)MiscConfig.CHARGING_STATION_GENERATE_SPEED.get();
    public static final int CHARGE_OTHER_SPEED = (Integer)MiscConfig.CHARGING_STATION_TRANSFER_SPEED.get();
    public static final int CHARGE_RADIUS = (Integer)MiscConfig.CHARGING_STATION_CHARGE_RADIUS.get();
    private LazyOptional<EnergyStorage> energyHandler;
    private LazyOptional<?>[] itemHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    public int fuelTick = 0;
    public int maxFuelTick = DEFAULT_FUEL_TIME;
    public boolean showRange = false;
    protected final ContainerEnergyData dataAccess = new ContainerEnergyData(){

        @Override
        public long get(int pIndex) {
            return switch (pIndex) {
                case 0 -> ChargingStationBlockEntity.this.fuelTick;
                case 1 -> ChargingStationBlockEntity.this.maxFuelTick;
                case 2 -> {
                    AtomicInteger energy = new AtomicInteger();
                    ChargingStationBlockEntity.this.getCapability(ForgeCapabilities.ENERGY).ifPresent(consumer -> energy.set(consumer.getEnergyStored()));
                    yield energy.get();
                }
                case 3 -> {
                    if (ChargingStationBlockEntity.this.showRange) {
                        yield 1L;
                    }
                    yield 0L;
                }
                default -> 0L;
            };
        }

        @Override
        public void set(int pIndex, long pValue) {
            switch (pIndex) {
                case 0: {
                    ChargingStationBlockEntity.this.fuelTick = (int)pValue;
                    break;
                }
                case 1: {
                    ChargingStationBlockEntity.this.maxFuelTick = (int)pValue;
                    break;
                }
                case 2: {
                    ChargingStationBlockEntity.this.getCapability(ForgeCapabilities.ENERGY).ifPresent(consumer -> consumer.receiveEnergy((int)pValue, false));
                    break;
                }
                case 3: {
                    ChargingStationBlockEntity.this.showRange = pValue == 1L;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };

    public ChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHARGING_STATION.get(), pos, state);
        this.energyHandler = LazyOptional.of(() -> new EnergyStorage(MAX_ENERGY));
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ChargingStationBlockEntity blockEntity) {
        if (blockEntity.showRange != (Boolean)pState.m_61143_((Property)ChargingStationBlock.SHOW_RANGE)) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)ChargingStationBlock.SHOW_RANGE, (Comparable)Boolean.valueOf(blockEntity.showRange)));
            ChargingStationBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        blockEntity.energyHandler.ifPresent(handler -> {
            int energy = handler.getEnergyStored();
            if (energy > 0) {
                blockEntity.chargeEntity((EnergyStorage)handler);
            }
            if (handler.getEnergyStored() > 0) {
                blockEntity.chargeItemStack((EnergyStorage)handler);
            }
            if (handler.getEnergyStored() > 0) {
                blockEntity.chargeBlock((EnergyStorage)handler);
            }
        });
        if (blockEntity.fuelTick > 0) {
            --blockEntity.fuelTick;
            blockEntity.energyHandler.ifPresent(handler -> {
                int energy = handler.getEnergyStored();
                if (energy < handler.getMaxEnergyStored()) {
                    handler.receiveEnergy(CHARGE_SPEED, false);
                }
            });
        } else if (!blockEntity.m_8020_(0).m_41619_()) {
            AtomicBoolean flag = new AtomicBoolean(false);
            blockEntity.energyHandler.ifPresent(handler -> {
                if (handler.getEnergyStored() >= handler.getMaxEnergyStored()) {
                    flag.set(true);
                }
            });
            if (flag.get()) {
                return;
            }
            ItemStack fuel = blockEntity.m_8020_(0);
            int burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
            if (fuel.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                fuel.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> blockEntity.energyHandler.ifPresent(energy -> {
                    int energyToExtract = Math.min(CHARGE_OTHER_SPEED, energy.getMaxEnergyStored() - energy.getEnergyStored());
                    if (itemEnergy.canExtract() && energy.canReceive()) {
                        energy.receiveEnergy(itemEnergy.extractEnergy(energyToExtract, false), false);
                    }
                }));
                blockEntity.m_6596_();
            } else if (burnTime > 0) {
                blockEntity.fuelTick = burnTime;
                blockEntity.maxFuelTick = burnTime;
                if (fuel.hasCraftingRemainingItem()) {
                    if (fuel.m_41613_() <= 1) {
                        blockEntity.m_6836_(0, fuel.getCraftingRemainingItem());
                    } else {
                        ItemStack copy = fuel.getCraftingRemainingItem().m_41777_();
                        copy.m_41764_(1);
                        ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.2, (double)pPos.m_123343_() + 0.5, copy);
                        pLevel.m_7967_((Entity)itemEntity);
                        fuel.m_41774_(1);
                    }
                } else {
                    fuel.m_41774_(1);
                }
                blockEntity.m_6596_();
            } else if (fuel.m_41720_().m_41472_()) {
                FoodProperties properties = fuel.getFoodProperties(null);
                if (properties == null) {
                    return;
                }
                int nutrition = properties.m_38744_();
                float saturation = properties.m_38745_() * 2.0f * (float)nutrition;
                int tick = nutrition * 80 + (int)(saturation * 200.0f);
                if (fuel.hasCraftingRemainingItem()) {
                    tick += 400;
                }
                fuel.m_41774_(1);
                blockEntity.fuelTick = tick;
                blockEntity.maxFuelTick = tick;
                blockEntity.m_6596_();
            }
        }
    }

    private void chargeEntity(EnergyStorage handler) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L != 0L) {
            return;
        }
        List entities = this.f_58857_.m_45976_(Entity.class, new AABB(this.m_58899_()).m_82400_((double)CHARGE_RADIUS));
        entities.forEach(entity -> entity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            if (cap.canReceive()) {
                int charged = cap.receiveEnergy(Math.min(handler.getEnergyStored(), CHARGE_OTHER_SPEED * 20), false);
                handler.extractEnergy(charged, false);
            }
        }));
        this.m_6596_();
    }

    private void chargeItemStack(EnergyStorage handler) {
        ItemStack stack = this.m_8020_(1);
        if (stack.m_41619_()) {
            return;
        }
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(consumer -> {
            if (consumer.getEnergyStored() < consumer.getMaxEnergyStored()) {
                int charged = consumer.receiveEnergy(Math.min(CHARGE_OTHER_SPEED, handler.getEnergyStored()), false);
                handler.extractEnergy(Math.min(charged, handler.getEnergyStored()), false);
            }
        });
        this.m_6596_();
    }

    private void chargeBlock(EnergyStorage handler) {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ENERGY).isPresent() || blockEntity instanceof ChargingStationBlockEntity) continue;
            blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (energy.canReceive() && energy.getEnergyStored() < energy.getMaxEnergyStored()) {
                    int receiveEnergy = energy.receiveEnergy(Math.min(handler.getEnergyStored(), CHARGE_OTHER_SPEED), false);
                    handler.extractEnergy(receiveEnergy, false);
                    blockEntity.m_6596_();
                    this.m_6596_();
                }
            });
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("Energy")) {
            this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> ((EnergyStorage)handler).deserializeNBT(pTag.m_128423_("Energy")));
        }
        this.fuelTick = pTag.m_128451_("FuelTick");
        this.maxFuelTick = pTag.m_128451_("MaxFuelTick");
        this.showRange = pTag.m_128471_("ShowRange");
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> pTag.m_128365_("Energy", ((EnergyStorage)handler).serializeNBT()));
        pTag.m_128405_("FuelTick", this.fuelTick);
        pTag.m_128405_("MaxFuelTick", this.maxFuelTick);
        pTag.m_128379_("ShowRange", this.showRange);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public int[] m_7071_(Direction pSide) {
        return new int[]{0};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return pIndex == 0;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pSlot == 0 && !flag) {
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.superbwarfare.charging_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ChargingStationMenu(pContainerId, pPlayerInventory, (Container)this, this.dataAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.items, (boolean)true);
        compoundtag.m_128379_("ShowRange", this.showRange);
        return compoundtag;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        if (!this.f_58859_ && side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.itemHandlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.itemHandlers[1].cast();
            }
            return this.itemHandlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> itemHandler : this.itemHandlers) {
            itemHandler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
        this.energyHandler = LazyOptional.of(() -> new EnergyStorage(MAX_ENERGY));
    }

    public void m_187476_(ItemStack pStack) {
        CompoundTag tag = new CompoundTag();
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> tag.m_128365_("Energy", ((EnergyStorage)handler).serializeNBT()));
        BlockItem.m_186338_((ItemStack)pStack, (BlockEntityType)this.m_58903_(), (CompoundTag)tag);
    }
}

