/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.client.overlay.SpyglassRangeOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class DroneHudOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_drone_hud";
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/frame/frame.png");
    private static final ResourceLocation TV_FRAME = Mod.loc("textures/screens/land/tv_frame.png");

    public static int getMaxDistance() {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        return (connection == null ? 16 : connection.f_194190_) * 16;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        boolean firstPerson;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ItemStack stack = player.m_21205_();
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = firstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK;
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
            if (firstPerson) {
                ItemStack offStack;
                guiGraphics.m_280163_(Mod.loc("textures/screens/drone.png"), screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
                guiGraphics.m_280163_(Mod.loc("textures/screens/drone_fov.png"), screenWidth / 2 + 100, screenHeight / 2 - 64, 0.0f, 0.0f, 64, 129, 64, 129);
                int addW = screenWidth / screenHeight * 48;
                int addH = screenWidth / screenHeight * 27;
                RenderHelper.preciseBlit(guiGraphics, TV_FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
                RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone_fov_move.png"), (float)screenWidth / 2.0f + 100.0f, (float)((double)((float)screenHeight / 2.0f - 64.0f) - (ClientEventHandler.droneFovLerp - 1.0) * 23.8), 0.0f, 0.0f, 64.0f, 129.0f, 64.0f, 129.0f);
                guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format1D(ClientEventHandler.droneFovLerp, "x")), screenWidth / 2 + 144, screenHeight / 2 + 56 - (int)((ClientEventHandler.droneFovLerp - 1.0) * 23.8), -1, false);
                DroneEntity entity = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
                if (entity != null) {
                    boolean lookAtEntity = false;
                    double distance = player.m_20182_().m_82546_(entity.m_20182_()).m_165924_();
                    BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(cameraPos, cameraPos.m_82549_(entity.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                    Vec3 hitPos = result.m_82450_();
                    double blockRange = cameraPos.m_82554_(hitPos);
                    double entityRange = 0.0;
                    Entity lookingEntity = TraceTool.droneFindLookingEntity(entity, cameraPos, 512.0, partialTick);
                    if (lookingEntity != null) {
                        lookAtEntity = true;
                        entityRange = entity.m_20270_(lookingEntity);
                    }
                    int color = -1;
                    if (distance > (double)(DroneHudOverlay.getMaxDistance() - 48)) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.warning"), screenWidth / 2 - 18, screenHeight / 2 - 47, -65536, false);
                        color = -65536;
                    }
                    guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.distance").m_7220_((Component)Component.m_237113_((String)FormatTool.format1D(distance, "m"))), screenWidth / 2 + 10, screenHeight / 2 + 33, color, false);
                    guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.health").m_7220_((Component)Component.m_237113_((String)(FormatTool.format1D(entity.getHealth()) + " / " + FormatTool.format1D(entity.getMaxHealth())))), screenWidth / 2 - 77, screenHeight / 2 + 33, -1, false);
                    if (!((Boolean)entity.m_20088_().m_135370_(DroneEntity.IS_KAMIKAZE)).booleanValue()) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.ammo").m_7220_((Component)Component.m_237113_((String)(entity.m_20088_().m_135370_(DroneEntity.AMMO) + " / " + entity.m_20088_().m_135370_(DroneEntity.MAX_AMMO)))), screenWidth / 2 + 12, screenHeight / 2 - 37, -1, false);
                    } else {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.kamikaze"), screenWidth / 2 + 12, screenHeight / 2 - 37, -65536, false);
                    }
                    if (lookAtEntity) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)(FormatTool.format1D(entityRange, "m ") + lookingEntity.m_5446_().getString()))), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    } else if (blockRange > 500.0) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)"---m")), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    } else {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)FormatTool.format1D(blockRange, "m"))), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    }
                    List<Entity> entities = SeekTool.seekLivingEntities(entity, entity.m_9236_(), 256.0, 30.0);
                    for (Entity e : entities) {
                        Vec3 pos = new Vec3(Mth.m_14139_((double)partialTick, (double)e.f_19854_, (double)e.m_20185_()), Mth.m_14139_((double)partialTick, (double)(e.f_19855_ + (double)e.m_20192_()), (double)e.m_20188_()), Mth.m_14139_((double)partialTick, (double)e.f_19856_, (double)e.m_20189_()));
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        poseStack.m_85836_();
                        float x = (float)point.f_82479_;
                        float y = (float)point.f_82480_;
                        RenderHelper.blit(poseStack, FRAME, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        poseStack.m_85849_();
                    }
                }
                if ((offStack = player.m_21206_()).m_150930_((Item)ModItems.FIRING_PARAMETERS.get()) || offStack.m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                    double targetX = offStack.m_41784_().m_128459_("TargetX");
                    double targetY = offStack.m_41784_().m_128459_("TargetY");
                    double targetZ = offStack.m_41784_().m_128459_("TargetZ");
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Vec3 pos = new Vec3(targetX, targetY, targetZ);
                    if (VectorUtil.canSee(pos)) {
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        float x = (float)point.f_82479_;
                        float y = (float)point.f_82480_;
                        RenderHelper.preciseBlit(guiGraphics, SpyglassRangeOverlay.INDICATOR, Mth.m_14036_((float)(x - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(y - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                    }
                    if (offStack.m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                        ListTag tags = offStack.m_41784_().m_128437_("Cannons", 10);
                        for (int m = 0; m < tags.size(); ++m) {
                            CompoundTag tag = tags.m_128728_(m);
                            Entity e = EntityFindUtil.findEntity(player.m_9236_(), tag.m_128461_("UUID"));
                            if (e == null || !VectorUtil.canSee(e.m_20182_())) continue;
                            Vec3 posF = e.m_20191_().m_82399_();
                            Vec3 pointF = VectorUtil.worldToScreen(posF);
                            float xf = (float)pointF.f_82479_;
                            float yf = (float)pointF.f_82480_;
                            RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_ARTILLERY, Mth.m_14036_((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                        }
                    }
                }
            } else if (VectorUtil.canSee(player.m_20182_())) {
                LocalPlayer team = player;
                if (player.m_20202_() != null) {
                    team = player.m_20202_();
                }
                Vec3 pos = new Vec3(Mth.m_14139_((double)partialTick, (double)team.f_19854_, (double)team.m_20185_()), Mth.m_14139_((double)partialTick, (double)(team.f_19855_ + (double)(team.m_20206_() / 2.0f)), (double)(team.m_20186_() + (double)(team.m_20206_() / 2.0f))), Mth.m_14139_((double)partialTick, (double)team.f_19856_, (double)team.m_20189_()));
                Vec3 point = VectorUtil.worldToScreen(pos);
                float xf = (float)point.f_82479_;
                float yf = (float)point.f_82480_;
                RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_INDICATOR, Mth.m_14036_((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

