/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import com.atsuishio.superbwarfare.tools.animation.AnimationTimer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class HeatBarOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_heat_bar";
    private static final ResourceLocation TEXTURE = Mod.loc("textures/screens/heat_bar.png");
    private static final AnimationTimer timer = new AnimationTimer(200L).animation(AnimationCurves.EASE_IN_QUART);

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ArmedVehicleEntity iArmedVehicle;
        Entity entity;
        if (!((Boolean)DisplayConfig.ENABLE_HEAT_BAR_HUD.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        double heat = ClientEventHandler.isEditing || !(player.m_21205_().m_41720_() instanceof GunItem) || (entity = player.m_20202_()) instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((Player)player) ? 0.0 : GunData.from((ItemStack)player.m_21205_()).heat.get();
        long currentTime = System.currentTimeMillis();
        if (heat <= 0.0) {
            timer.forward(currentTime);
        } else {
            timer.beginForward(currentTime);
        }
        if (timer.finished(currentTime)) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int width = 16;
        int height = 64;
        int i = (screenWidth - width) / 2;
        int j = (screenHeight - height) / 2;
        float posX = (float)(i + 64 + (Integer)DisplayConfig.HEAT_BAR_HUD_X_OFFSET.get()) + timer.lerp(0.0f, 5.0f, currentTime);
        float posY = j + 6 + (Integer)DisplayConfig.HEAT_BAR_HUD_Y_OFFSET.get();
        float alpha = timer.lerp(1.0f, 0.0f, currentTime);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderHelper.preciseBlit(guiGraphics, TEXTURE, posX, posY, 0.0f, 0.0f, 9.25f, 58.25f, width, height);
        float rate = (float)(heat / 100.0);
        float barHeight = 56.0f * rate;
        poseStack.m_85836_();
        RenderHelper.blit(poseStack, TEXTURE, posX + 2.5f, posY + 1.5f + 56.0f - barHeight, 10.5f, 0.0f, 2.25f, barHeight, (float)width, (float)height, rate >= 0.795f ? HeatBarOverlay.calculateGradientColor(rate) : 0xFFFFFF);
        poseStack.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static int calculateGradientColor(float rate) {
        float clampedRate = Mth.m_14036_((float)rate, (float)0.795f, (float)1.0f);
        float normalized = (clampedRate - 0.795f) / 0.20499998f;
        int red = 255;
        int green = (int)(255.0f * (1.0f - normalized));
        int blue = (int)(255.0f * (1.0f - normalized));
        return red << 16 | green << 8 | blue;
    }
}

