/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.entity.vehicle.Type63Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class Type63InfoOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_type_63_info";
    private static final ItemStack AP = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_AP.get());
    private static final ItemStack HE = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_HE.get());
    private static final ItemStack CM = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_CM.get());

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        PoseStack poseStack = guiGraphics.m_280168_();
        if (player == null) {
            return;
        }
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, player.getEntityReach());
        if (!(lookingEntity instanceof Type63Entity)) {
            return;
        }
        Type63Entity type63Entity = (Type63Entity)lookingEntity;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.mortar.pitch").m_7220_((Component)Component.m_237113_((String)FormatTool.format2D(((Float)type63Entity.m_20088_().m_135370_(Type63Entity.SHOOT_PITCH)).floatValue(), "\u00b0"))), screenWidth / 2 - 130, screenHeight / 2 - 26, -1, false);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.mortar.yaw").m_7220_((Component)Component.m_237113_((String)FormatTool.format2D(((Float)type63Entity.m_20088_().m_135370_(Type63Entity.SHOOT_YAW)).floatValue(), "\u00b0"))), screenWidth / 2 - 130, screenHeight / 2 - 16, -1, false);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.mortar.range").m_7220_((Component)Component.m_237113_((String)FormatTool.format1D(Math.max((int)RangeTool.getRange(((Float)type63Entity.m_20088_().m_135370_(Type63Entity.SHOOT_PITCH)).floatValue(), 10.0, 0.05), 0), "m"))), screenWidth / 2 - 130, screenHeight / 2 - 6, -1, false);
        IntList items = (IntList)type63Entity.m_20088_().m_135370_(Type63Entity.LOADED_AMMO);
        for (int i = 0; i < type63Entity.barrel.length; ++i) {
            if (OBB.getLookingObb((Player)player, player.getEntityReach()) != type63Entity.barrel[i]) continue;
            int type = items.getInt(i);
            ItemStack stack = switch (type) {
                case 0 -> AP;
                case 1 -> HE;
                case 2 -> CM;
                default -> ItemStack.f_41583_;
            };
            Vec3 pos = new Vec3(type63Entity.barrel[i].center());
            Vec3 point = VectorUtil.worldToScreen(pos);
            poseStack.m_85836_();
            float x = (float)point.f_82479_;
            float y = (float)point.f_82480_;
            Component component = stack.m_41786_();
            if (stack.m_41619_()) {
                component = Component.m_237115_((String)"tips.superbwarfare.barrel_empty");
                width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                poseStack.m_252880_(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, component, 0, 0, -1, false);
            } else {
                width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component) + 20;
                poseStack.m_85836_();
                poseStack.m_252880_(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.m_280203_(stack, 0, 0);
                poseStack.m_252880_(20.0f, 4.0f, 0.0f);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, component, 0, 0, -1, false);
            }
            poseStack.m_85849_();
        }
        ItemStack stack = player.m_21206_();
        if (player.m_21205_().m_41720_() instanceof FiringParameters) {
            stack = player.m_21205_();
        }
        if (stack.m_41720_() instanceof FiringParameters) {
            double targetX = stack.m_41784_().m_128459_("TargetX");
            double targetY = stack.m_41784_().m_128459_("TargetY") - 1.0;
            double targetZ = stack.m_41784_().m_128459_("TargetZ");
            boolean isDepressed = stack.m_41784_().m_128471_("IsDepressed");
            Vec3 targetPos = new Vec3(targetX, targetY, targetZ);
            Vec3 launchVector = RangeTool.calculateLaunchVector(type63Entity.getShootPos(partialTick), targetPos, 10.0, 0.05, isDepressed);
            Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.m_90377_(lookingEntity);
            double d0 = (targetPos.f_82479_ - vec3.f_82479_) * 0.2;
            double d2 = (targetPos.f_82481_ - vec3.f_82481_) * 0.2;
            double targetYaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            if (launchVector == null) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.mortar.out_of_range").m_130940_(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 - 26, -1, false);
                return;
            }
            float angle = (float)VehicleEntity.getXRotFromVector(launchVector);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.target.pitch").m_7220_((Component)Component.m_237113_((String)FormatTool.format2D(angle, "\u00b0"))), screenWidth / 2 + 90, screenHeight / 2 - 26, -1, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.target.yaw").m_7220_((Component)Component.m_237113_((String)FormatTool.format2D(targetYaw, "\u00b0"))), screenWidth / 2 + 90, screenHeight / 2 - 16, -1, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.mortar.target_pos").m_7220_((Component)Component.m_237113_((String)(FormatTool.format0D(targetX) + " " + FormatTool.format0D(targetY) + " " + FormatTool.format0D(targetZ)))), screenWidth / 2 + 90, screenHeight / 2 - 6, -1, false);
            if (angle < -5.0f || angle > 60.0f) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{lookingEntity.m_5446_()}).m_130940_(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 + 4, -1, false);
                if (angle > 60.0f && !isDepressed) {
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.ballistics.warn").m_130940_(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 + 14, -1, false);
                }
            }
        }
    }
}

