/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.menu.ReforgingTableMenu;
import com.atsuishio.superbwarfare.network.message.send.GunReforgeMessage;
import com.atsuishio.superbwarfare.network.message.send.SetPerkLevelMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ReforgingTableScreen
extends AbstractContainerScreen<ReforgingTableMenu> {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/reforging_table.png");

    public ReforgingTableScreen(ReforgingTableMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 177;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 200, 200);
        RenderSystem.disableBlend();
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int ammoPerkLevel = ((ReforgingTableMenu)this.f_97732_).ammoPerkLevel.m_6501_();
        int funcPerkLevel = ((ReforgingTableMenu)this.f_97732_).funcPerkLevel.m_6501_();
        int damagePerkLevel = ((ReforgingTableMenu)this.f_97732_).damagePerkLevel.m_6501_();
        if (ammoPerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.f_97735_ + 136, this.f_97736_ + 31, 1, 178, ammoPerkLevel);
        }
        if (funcPerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.f_97735_ + 146, this.f_97736_ + 31, 1, 184, funcPerkLevel);
        }
        if (damagePerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.f_97735_ + 156, this.f_97736_ + 31, 1, 190, damagePerkLevel);
        }
        int upgradePoint = ((ReforgingTableMenu)this.f_97732_).upgradePoint.m_6501_();
        this.renderNumber(pGuiGraphics, this.f_97735_ + 43, this.f_97736_ + 20, 51, 178, upgradePoint);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderNumber(GuiGraphics guiGraphics, int x, int y, int u, int v, int number) {
        int g = number / 10;
        int s = number % 10;
        guiGraphics.m_280163_(TEXTURE, x, y, (float)(u + 5 * g), (float)v, 5, 5, 200, 200);
        guiGraphics.m_280163_(TEXTURE, x + 4, y, (float)(u + 5 * s), (float)v, 5, 5, 200, 200);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 2;
        this.f_97730_ = 8;
        this.f_97731_ = 85;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        ReforgeButton button = new ReforgeButton(i + 124, j + 70);
        UpgradeButton ammoUpgrade = new UpgradeButton(i + 98, j + 21, Perk.Type.AMMO);
        DowngradeButton ammoDowngrade = new DowngradeButton(i + 69, j + 21, Perk.Type.AMMO);
        UpgradeButton funcUpgrade = new UpgradeButton(i + 98, j + 41, Perk.Type.FUNCTIONAL);
        DowngradeButton funcDowngrade = new DowngradeButton(i + 69, j + 41, Perk.Type.FUNCTIONAL);
        UpgradeButton damageUpgrade = new UpgradeButton(i + 98, j + 61, Perk.Type.DAMAGE);
        DowngradeButton damageDowngrade = new DowngradeButton(i + 69, j + 61, Perk.Type.DAMAGE);
        this.m_142416_((GuiEventListener)button);
        this.m_142416_((GuiEventListener)ammoUpgrade);
        this.m_142416_((GuiEventListener)ammoDowngrade);
        this.m_142416_((GuiEventListener)funcUpgrade);
        this.m_142416_((GuiEventListener)funcDowngrade);
        this.m_142416_((GuiEventListener)damageUpgrade);
        this.m_142416_((GuiEventListener)damageDowngrade);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ReforgeButton
    extends AbstractButton {
        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_274382_() ? 81.0f : 51.0f, 184.0f, 29, 15, 200, 200);
        }

        public ReforgeButton(int pX, int pY) {
            super(pX, pY, 40, 16, (Component)Component.m_237119_());
        }

        public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        public void m_5691_() {
            Mod.PACKET_HANDLER.sendToServer((Object)GunReforgeMessage.INSTANCE);
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class UpgradeButton
    extends AbstractButton {
        public Perk.Type type;

        public UpgradeButton(int pX, int pY, Perk.Type type) {
            super(pX, pY, 9, 9, (Component)Component.m_237119_());
            this.type = type;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 187.0f, this.m_274382_() ? 10.0f : 0.0f, 9, 9, 200, 200);
        }

        public void m_5691_() {
            if (((ReforgingTableMenu)ReforgingTableScreen.this.f_97732_).getPerkItemBySlot(this.type) == ItemStack.f_41583_) {
                return;
            }
            switch (this.type) {
                case AMMO: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).ammoPerkLevel.m_6501_() < 20) break;
                    return;
                }
                case FUNCTIONAL: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).funcPerkLevel.m_6501_() < 20) break;
                    return;
                }
                case DAMAGE: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).damagePerkLevel.m_6501_() < 20) break;
                    return;
                }
            }
            Mod.PACKET_HANDLER.sendToServer((Object)new SetPerkLevelMessage(this.type.ordinal(), true));
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class DowngradeButton
    extends AbstractButton {
        public Perk.Type type;

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 177.0f, this.m_274382_() ? 10.0f : 0.0f, 9, 9, 200, 200);
        }

        public DowngradeButton(int pX, int pY, Perk.Type type) {
            super(pX, pY, 12, 12, (Component)Component.m_237119_());
            this.type = type;
        }

        public void m_5691_() {
            if (((ReforgingTableMenu)ReforgingTableScreen.this.f_97732_).getPerkItemBySlot(this.type) == ItemStack.f_41583_) {
                return;
            }
            switch (this.type) {
                case AMMO: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).ammoPerkLevel.m_6501_() > 1) break;
                    return;
                }
                case FUNCTIONAL: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).funcPerkLevel.m_6501_() > 1) break;
                    return;
                }
                case DAMAGE: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).f_97732_).damagePerkLevel.m_6501_() > 1) break;
                    return;
                }
            }
            Mod.PACKET_HANDLER.sendToServer((Object)new SetPerkLevelMessage(this.type.ordinal(), false));
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

