/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.send.EditMessage;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeaponEditScreen
extends Screen {
    private static final ResourceLocation BARREL = Mod.loc("textures/gui/attachment/barrel.png");
    private static final ResourceLocation SCOPE = Mod.loc("textures/gui/attachment/scope.png");
    private static final ResourceLocation GRIP = Mod.loc("textures/gui/attachment/grip.png");
    private static final ResourceLocation STOCK = Mod.loc("textures/gui/attachment/stock.png");
    private static final ResourceLocation MAGAZINE = Mod.loc("textures/gui/attachment/magazine.png");
    private static final ResourceLocation AMMO_TYPE = Mod.loc("textures/gui/attachment/ammo_type.png");
    private static final ResourceLocation INVALID = Mod.loc("textures/gui/attachment/invalid.png");
    private static final ResourceLocation BUTTON_LEFT = Mod.loc("textures/gui/attachment/button_left.png");
    private static final ResourceLocation BUTTON_RIGHT = Mod.loc("textures/gui/attachment/button_right.png");
    private static final ResourceLocation BUTTON_LEFT_HOVERED = Mod.loc("textures/gui/attachment/button_left_hovered.png");
    private static final ResourceLocation BUTTON_RIGHT_HOVERED = Mod.loc("textures/gui/attachment/button_right_hovered.png");
    private static final ResourceLocation CHOSEN = Mod.loc("textures/gui/attachment/chosen.png");
    private static final ResourceLocation NOT_CHOSEN = Mod.loc("textures/gui/attachment/not_chosen.png");
    private final ItemStack stack;

    public WeaponEditScreen(ItemStack stack) {
        super((Component)Component.m_237119_());
        this.stack = stack;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderEdit(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderEdit(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.stack.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (itemStack.m_41720_() != this.stack.m_41720_()) {
            return;
        }
        PoseStack pose = pGuiGraphics.m_280168_();
        pose.m_85836_();
        pGuiGraphics.m_280509_(this.f_96543_ - 165, 4, this.f_96543_ - 4, 110, Integer.MIN_VALUE);
        pGuiGraphics.m_280614_(this.f_96547_, this.stack.m_41786_(), this.f_96543_ - 161, 6, 0xFFFFFF, false);
        pGuiGraphics.m_280509_(this.f_96543_ - 163, 16, Math.min(this.f_96543_ + this.f_96547_.m_92852_((FormattedText)this.stack.m_41786_()) - 159, this.f_96543_ - 6), 17, -1);
        int posX1 = this.f_96543_ - 163;
        int posX2 = this.f_96543_ - 85;
        int posY1 = 20;
        int posY2 = 50;
        int posY3 = 80;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.preciseBlit(pGuiGraphics, BARREL, posX1, posY1, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (!gunItem.hasCustomBarrel(this.stack)) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX1, posY1, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        }
        RenderHelper.preciseBlit(pGuiGraphics, SCOPE, posX2, posY1, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (!gunItem.hasCustomScope(this.stack)) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX2, posY1, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        }
        RenderHelper.preciseBlit(pGuiGraphics, GRIP, posX1, posY2, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (!gunItem.hasCustomGrip(this.stack)) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX1, posY2, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        }
        RenderHelper.preciseBlit(pGuiGraphics, STOCK, posX2, posY2, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (!gunItem.hasCustomStock(this.stack)) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX2, posY2, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        }
        RenderHelper.preciseBlit(pGuiGraphics, MAGAZINE, posX1, posY3, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (!gunItem.hasCustomMagazine(this.stack)) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX1, posY3, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        }
        GunData currentData = GunData.from(itemStack);
        RenderHelper.preciseBlit(pGuiGraphics, AMMO_TYPE, posX2, posY3, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        if (currentData.ammoConsumers.size() <= 1) {
            RenderHelper.preciseBlit(pGuiGraphics, INVALID, posX2, posY3, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
        } else {
            int size = currentData.ammoConsumers.size();
            float offset = 35.0f;
            int count = size / 2;
            float tempPos = size % 2 == 0 ? (float)(this.f_96543_ - count * 6 + 1) : (float)(this.f_96543_ - count * 6 - 2);
            for (int i = 0; i < size; ++i) {
                RenderHelper.preciseBlit(pGuiGraphics, i == currentData.selectedAmmoType.get() ? CHOSEN : NOT_CHOSEN, tempPos - offset + (float)(6 * i), posY3, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, 4.0f);
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        int posX1 = this.f_96543_ - 133;
        int posX2 = this.f_96543_ - 55;
        int posY1 = 26;
        int posY2 = 56;
        int posY3 = 86;
        this.m_142416_((GuiEventListener)new EditButton(posX1, posY1, 16, 16, 0, true));
        this.m_142416_((GuiEventListener)new EditButton(posX1 + 24, posY1, 16, 16, 0, false));
        this.m_142416_((GuiEventListener)new EditButton(posX2, posY1, 16, 16, 1, true));
        this.m_142416_((GuiEventListener)new EditButton(posX2 + 24, posY1, 16, 16, 1, false));
        this.m_142416_((GuiEventListener)new EditButton(posX1, posY2, 16, 16, 2, true));
        this.m_142416_((GuiEventListener)new EditButton(posX1 + 24, posY2, 16, 16, 2, false));
        this.m_142416_((GuiEventListener)new EditButton(posX2, posY2, 16, 16, 3, true));
        this.m_142416_((GuiEventListener)new EditButton(posX2 + 24, posY2, 16, 16, 3, false));
        this.m_142416_((GuiEventListener)new EditButton(posX1, posY3, 16, 16, 4, true));
        this.m_142416_((GuiEventListener)new EditButton(posX1 + 24, posY3, 16, 16, 4, false));
        this.m_142416_((GuiEventListener)new EditButton(posX2, posY3, 16, 16, 5, true));
        this.m_142416_((GuiEventListener)new EditButton(posX2 + 24, posY3, 16, 16, 5, false));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX < (double)(this.f_96543_ - 165) || pMouseY < 4.0 || pMouseX > (double)(this.f_96543_ - 4) || pMouseY > 110.0) {
            this.m_7379_();
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_7379_() {
        super.m_7379_();
        ClientEventHandler.onCloseEditScreen();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == ModKeyMappings.EDIT_MODE.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    class EditButton
    extends AbstractButton {
        public int type;
        public boolean left;

        public EditButton(int pX, int pY, int pWidth, int pHeight, int type, boolean left) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
            this.type = type;
            this.left = left;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (this.f_93622_ && this.m_142518_()) {
                pGuiGraphics.m_280163_(this.left ? BUTTON_LEFT_HOVERED : BUTTON_RIGHT_HOVERED, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
            } else {
                pGuiGraphics.m_280163_(this.left ? BUTTON_LEFT : BUTTON_RIGHT, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pGuiGraphics.m_280168_().m_85849_();
        }

        public void m_5691_() {
            if (!this.m_142518_()) {
                return;
            }
            Mod.PACKET_HANDLER.sendToServer((Object)new EditMessage(this.type, !this.left));
            ClientEventHandler.editModelShake();
        }

        public boolean m_142518_() {
            ItemStack stack = WeaponEditScreen.this.stack;
            Item item = stack.m_41720_();
            if (!(item instanceof GunItem)) {
                return false;
            }
            GunItem gunItem = (GunItem)item;
            GunData data = GunData.from(stack);
            return switch (this.type) {
                case 0 -> gunItem.hasCustomBarrel(stack);
                case 1 -> gunItem.hasCustomScope(stack);
                case 2 -> gunItem.hasCustomGrip(stack);
                case 3 -> gunItem.hasCustomStock(stack);
                case 4 -> gunItem.hasCustomMagazine(stack);
                case 5 -> {
                    if (data.ammoConsumers.size() > 1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

