/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Prop<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA, FIELD> {
    public static final List<Prop<?, ?, ?>> props = new ArrayList();
    public final Class<DEFAULT_DATA> rawDataType;
    public final String name;
    protected final Field field;
    public Function<DEFAULT_DATA, FIELD> specialSupplier;
    public PropModifyContext<DATA, FIELD> limiter;

    protected Prop(Class<DEFAULT_DATA> rawDataType, String name) {
        this.rawDataType = rawDataType;
        this.name = name;
        try {
            this.field = Arrays.stream(this.rawDataType.getFields()).filter(f -> {
                SerializedName annotation = f.getAnnotation(SerializedName.class);
                return annotation != null && annotation.value().equals(this.name);
            }).findFirst().orElseThrow();
            this.field.setAccessible(true);
        }
        catch (Exception exception) {
            Mod.LOGGER.error("Could not find field {} in RAW_DATA!", (Object)name);
            throw new RuntimeException(exception);
        }
        props.add(this);
    }

    public Type getFieldType() {
        return this.field.getGenericType();
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withSupplier(Function<DEFAULT_DATA, FIELD> supplier) {
        this.specialSupplier = supplier;
        return (T)this;
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withLimiter(PropModifyContext<DATA, FIELD> limiter) {
        this.limiter = limiter;
        return (T)this;
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withLimiter(Function<FIELD, FIELD> limiter) {
        return this.withLimiter((DATA data, FIELD value) -> limiter.apply(value));
    }

    public FIELD getDefault(DEFAULT_DATA data) {
        if (this.specialSupplier != null) {
            return this.specialSupplier.apply(data);
        }
        try {
            return (FIELD)DataLoader.processValue(this.field.get(data));
        }
        catch (Exception exception) {
            Mod.LOGGER.error("Could not get field {} in RAW_DATA!", (Object)this.name);
            throw new RuntimeException(exception);
        }
    }

    public PropModifier asModifier(DATA data) {
        return new PropModifier(this, data, this.getDefault(data.getDefault()), this.limiter);
    }

    @Nullable
    public static <T extends Prop<?, ?, ?>> T getByName(String name) {
        return (T)((Prop)props.stream().filter(p -> p.name.equals(name)).findFirst().orElse(null));
    }

    @FunctionalInterface
    public static interface PropModifyContext<DATA, FIELD> {
        public FIELD apply(@NotNull DATA var1, @NotNull FIELD var2);
    }

    public static class PropModifier {
        private final DATA data;
        private final FIELD value;
        private final PropModifyContext<DATA, FIELD> limiter;
        private final List<PropModifyContext<DATA, FIELD>> modifiers = new ArrayList();
        final /* synthetic */ Prop this$0;

        private PropModifier(DATA data, @Nullable FIELD value, PropModifyContext<DATA, FIELD> limiter) {
            this.this$0 = this$0;
            this.data = data;
            this.value = value;
            this.limiter = limiter;
        }

        public PropModifier apply(@Nullable List<PropModifyContext<DATA, FIELD>> modifiers) {
            if (modifiers == null) {
                return this;
            }
            for (PropModifyContext modifier : modifiers) {
                this.apply(modifier);
            }
            return this;
        }

        public PropModifier apply(@Nullable PropModifyContext<DATA, FIELD> modifier) {
            if (modifier == null) {
                return this;
            }
            this.modifiers.add(modifier);
            return this;
        }

        public PropModifier override(@Nullable FIELD value) {
            if (value == null) {
                return this;
            }
            this.modifiers.add((data, v) -> value);
            return this;
        }

        public FIELD compute() {
            Object result = this.value;
            for (PropModifyContext modifier : this.modifiers) {
                result = modifier.apply(this.data, result);
            }
            if (this.limiter != null) {
                result = this.limiter.apply(this.data, result);
            }
            return DataLoader.processValue(result);
        }
    }
}

