/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.google.gson.annotations.SerializedName;

public class DamageReduce {
    @SerializedName(value="Type")
    public ReduceType type = null;
    @SerializedName(value="Rate")
    private double rate;
    @SerializedName(value="MinDistance")
    private double minDistance;

    public DamageReduce() {
        this(ReduceType.EMPTY);
    }

    public DamageReduce(ReduceType type) {
        this.type = type;
        this.rate = type.rate;
        this.minDistance = type.minDistance;
    }

    public DamageReduce(double rate, double minDistance) {
        this.rate = rate;
        this.minDistance = minDistance;
    }

    public double getRate() {
        return this.type == null ? this.rate : this.type.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getMinDistance() {
        return this.type == null ? this.minDistance : this.type.minDistance;
    }

    public void setMinDistance(double minDistance) {
        this.minDistance = minDistance;
    }

    public static enum ReduceType {
        SHOTGUN("Shotgun", 0.05, 15.0),
        SNIPER("Sniper", 0.001, 150.0),
        HEAVY("Heavy", 7.0E-4, 250.0),
        HANDGUN("Handgun", 0.03, 40.0),
        RIFLE("Rifle", 0.007, 100.0),
        SMG("Smg", 0.02, 50.0),
        EMPTY("Empty", 0.0, 0.0);

        public final double rate;
        public final double minDistance;
        public final String name;

        private ReduceType(String name, double rate, double minDistance) {
            this.name = name;
            this.rate = rate;
            this.minDistance = minDistance;
        }

        public String toString() {
            return this.name;
        }
    }
}

