/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.drone_attachment.DroneAttachmentData;
import com.atsuishio.superbwarfare.entity.C4Entity;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DroneEntity
extends MobileVehicleEntity
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> CONTROLLER = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> IS_KAMIKAZE = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DELTA_X_ROT = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> DISPLAY_ENTITY = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<CompoundTag> DISPLAY_ENTITY_TAG = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<List<Float>> DISPLAY_DATA = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.FLOAT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Integer> MAX_AMMO = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean fire;
    public int collisionCoolDown;
    public double lastTickSpeed;
    public double lastTickVerticalSpeed;
    public ItemStack currentItem = ItemStack.f_41583_;
    public float pitch;
    public float pitchO;
    public int holdTickX;
    public int holdTickY;
    public int holdTickZ;

    public DroneEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DroneEntity>)((EntityType)ModEntities.DRONE.get()), world);
    }

    public DroneEntity(EntityType<DroneEntity> type, Level world) {
        super(type, world);
    }

    public float getBodyPitch() {
        return this.pitch;
    }

    public void setBodyXRot(float rot) {
        this.pitch = rot;
    }

    public float getBodyPitch(float tickDelta) {
        return Mth.m_14179_((float)(0.6f * tickDelta), (float)this.pitchO, (float)this.getBodyPitch());
    }

    public DroneEntity(EntityType<? extends DroneEntity> type, Level world, float moveX, float moveY, float moveZ) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        DroneAttachmentData data = new DroneAttachmentData();
        this.f_19804_.m_135372_(DELTA_X_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CONTROLLER, (Object)"undefined");
        this.f_19804_.m_135372_(LINKED, (Object)false);
        this.f_19804_.m_135372_(IS_KAMIKAZE, (Object)false);
        this.f_19804_.m_135372_(DISPLAY_ENTITY, (Object)"");
        this.f_19804_.m_135372_(DISPLAY_DATA, List.of(Float.valueOf(data.scale()[0]), Float.valueOf(data.scale()[1]), Float.valueOf(data.scale()[2]), Float.valueOf(data.offset()[0]), Float.valueOf(data.offset()[1]), Float.valueOf(data.offset()[2]), Float.valueOf(data.rotation()[0]), Float.valueOf(data.rotation()[1]), Float.valueOf(data.rotation()[2]), Float.valueOf(data.xLength), Float.valueOf(data.zLength), Float.valueOf(data.tickCount)));
        this.f_19804_.m_135372_(DISPLAY_ENTITY_TAG, (Object)new CompoundTag());
        this.f_19804_.m_135372_(MAX_AMMO, (Object)1);
    }

    public boolean m_142535_(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    @Override
    public boolean shouldSendHitParticles() {
        return false;
    }

    @Override
    public boolean shouldSendHitSounds() {
        return false;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Linked", ((Boolean)this.f_19804_.m_135370_(LINKED)).booleanValue());
        compound.m_128359_("Controller", (String)this.f_19804_.m_135370_(CONTROLLER));
        compound.m_128405_("Ammo", ((Integer)this.f_19804_.m_135370_(AMMO)).intValue());
        compound.m_128379_("KamikazeMode", ((Boolean)this.f_19804_.m_135370_(IS_KAMIKAZE)).booleanValue());
        compound.m_128405_("MaxAmmo", ((Integer)this.f_19804_.m_135370_(MAX_AMMO)).intValue());
        compound.m_128359_("DisplayEntity", (String)this.f_19804_.m_135370_(DISPLAY_ENTITY));
        compound.m_128359_("DisplayEntityTag", ((CompoundTag)this.f_19804_.m_135370_(DISPLAY_ENTITY_TAG)).toString());
        compound.m_128359_("DisplayData", ((List)this.f_19804_.m_135370_(DISPLAY_DATA)).stream().map(Object::toString).collect(Collectors.joining(",")));
        CompoundTag item = new CompoundTag();
        this.currentItem.m_41739_(item);
        compound.m_128365_("Item", (Tag)item);
    }

    @Override
    public boolean hasEnergyStorage() {
        return false;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Linked")) {
            this.f_19804_.m_135381_(LINKED, (Object)compound.m_128471_("Linked"));
        }
        if (compound.m_128441_("Controller")) {
            this.f_19804_.m_135381_(CONTROLLER, (Object)compound.m_128461_("Controller"));
        }
        if (compound.m_128441_("Ammo")) {
            this.f_19804_.m_135381_(AMMO, (Object)compound.m_128451_("Ammo"));
        }
        if (compound.m_128441_("KamikazeMode")) {
            this.f_19804_.m_135381_(IS_KAMIKAZE, (Object)compound.m_128471_("KamikazeMode"));
        }
        if (compound.m_128441_("Item")) {
            this.currentItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        }
        if (compound.m_128441_("MaxAmmo")) {
            this.f_19804_.m_135381_(MAX_AMMO, (Object)compound.m_128451_("MaxAmmo"));
        }
        if (compound.m_128441_("DisplayEntity")) {
            this.f_19804_.m_135381_(DISPLAY_ENTITY, (Object)compound.m_128461_("DisplayEntity"));
        }
        if (compound.m_128441_("DisplayEntityTag")) {
            this.f_19804_.m_135381_(DISPLAY_ENTITY_TAG, (Object)compound.m_128469_("DisplayEntityTag"));
        }
        if (compound.m_128441_("DisplayData")) {
            this.f_19804_.m_135381_(DISPLAY_DATA, Arrays.stream(compound.m_128461_("DisplayData").split(",")).map(Float::valueOf).collect(Collectors.toList()));
        }
    }

    @Override
    public int maxRepairCoolDown() {
        return -1;
    }

    @Override
    public void m_6075_() {
        this.pitchO = this.getBodyPitch();
        this.setBodyXRot(this.pitch * 0.9f);
        super.m_6075_();
        this.setZRot(this.getRoll() * 0.9f);
        this.lastTickSpeed = this.m_20184_().m_82553_();
        this.lastTickVerticalSpeed = this.m_20184_().f_82480_;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (!this.m_20096_() && controller != null) {
            ItemStack stack = controller.m_21205_();
            if (!stack.m_150930_((Item)ModItems.MONITOR.get()) || !stack.m_41784_().m_128471_("Using")) {
                this.upInputDown = false;
                this.downInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.leftInputDown = false;
                this.rightInputDown = false;
            }
            if (this.f_19797_ % 5 == 0) {
                controller.m_150109_().f_35974_.stream().filter(pStack -> pStack.m_41720_() == ModItems.MONITOR.get()).forEach(pStack -> {
                    if (pStack.m_41784_().m_128461_("LinkedDrone").equals(this.m_20149_())) {
                        Monitor.getDronePos(pStack, this.m_20182_());
                    }
                });
            }
        }
        if (this.m_20069_()) {
            this.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_), (Entity)controller), 0.25f + (float)(2.0 * this.lastTickSpeed));
        }
        if (this.fire && (Integer)this.f_19804_.m_135370_(AMMO) > 0) {
            if (!((Boolean)this.f_19804_.m_135370_(IS_KAMIKAZE)).booleanValue()) {
                this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.f_19804_.m_135370_(AMMO) - 1));
                if (controller != null && this.m_9236_() instanceof ServerLevel) {
                    this.droneDrop(controller);
                }
            } else if (controller != null) {
                if (controller.m_21205_().m_150930_((Item)ModItems.MONITOR.get())) {
                    Monitor.disLink(controller.m_21205_(), controller);
                }
                this.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_), (Entity)controller), 10000.0f);
            }
            this.fire = false;
        }
        this.m_6210_();
    }

    private void droneDrop(@Nullable Player player) {
        DroneAttachmentData data = (DroneAttachmentData)CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
        if (data == null) {
            return;
        }
        Entity dropEntity = EntityType.m_20632_((String)data.dropEntity()).map(type -> type.m_20615_(this.m_9236_())).orElse(null);
        if (dropEntity == null) {
            return;
        }
        if (player != null && dropEntity instanceof Projectile) {
            Projectile projectile = (Projectile)dropEntity;
            projectile.m_5602_((Entity)player);
        }
        CompoundTag tag = TagDataParser.parse(data.dropData(), name -> {
            if (player == null) {
                return StringTag.m_129297_((String)name);
            }
            UUID uuid = player.m_20148_();
            return switch (name) {
                case "@sbw:owner" -> NbtUtils.m_129226_((UUID)uuid);
                case "@sbw:owner_string_lower" -> StringTag.m_129297_((String)uuid.toString().replace("-", "").toLowerCase(Locale.ROOT));
                case "@sbw:owner_string_upper" -> StringTag.m_129297_((String)uuid.toString().replace("-", "").toUpperCase(Locale.ROOT));
                default -> StringTag.m_129297_((String)name);
            };
        });
        dropEntity.m_20258_(tag);
        float[] dropPos = data.dropPosition();
        dropEntity.m_6034_(this.m_20185_() + (double)dropPos[0], this.m_20186_() + (double)dropPos[1], this.m_20189_() + (double)dropPos[2]);
        Vec3 vec3 = new Vec3(0.2 * this.m_20184_().f_82479_, 0.2 * this.m_20184_().f_82480_, 0.2 * this.m_20184_().f_82481_);
        dropEntity.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        dropEntity.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        dropEntity.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        dropEntity.f_19859_ = dropEntity.m_146908_();
        dropEntity.f_19860_ = dropEntity.m_146909_();
        this.m_9236_().m_7967_(dropEntity);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == ModItems.MONITOR.get()) {
            if (!player.m_6047_()) {
                if (!((Boolean)this.f_19804_.m_135370_(LINKED)).booleanValue()) {
                    if (stack.m_41784_().m_128471_("Linked")) {
                        player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.monitor.already_linked").m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                    this.f_19804_.m_135381_(LINKED, (Object)true);
                    this.f_19804_.m_135381_(CONTROLLER, (Object)player.m_20149_());
                    Monitor.link(stack, this.m_20149_());
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.monitor.linked").m_130940_(ChatFormatting.GREEN), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.drone.already_linked").m_130940_(ChatFormatting.RED), true);
                }
            } else if (((Boolean)this.f_19804_.m_135370_(LINKED)).booleanValue()) {
                if (!stack.m_41784_().m_128471_("Linked")) {
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.drone.already_linked").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                this.f_19804_.m_135381_(CONTROLLER, (Object)"none");
                this.f_19804_.m_135381_(LINKED, (Object)false);
                Monitor.disLink(stack, player);
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.monitor.unlinked").m_130940_(ChatFormatting.RED), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        } else if (player.m_6047_()) {
            if (stack.m_41619_() || stack.m_204117_(ModTags.Items.CROWBAR)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.DRONE.get()));
                for (int index0 = 0; index0 < (Integer)this.f_19804_.m_135370_(AMMO); ++index0) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentItem.m_41777_());
                }
                player.m_150109_().f_35974_.stream().filter(stack_ -> stack_.m_41720_() == ModItems.MONITOR.get()).forEach(itemStack -> {
                    if (itemStack.m_41784_().m_128461_("LinkedDrone").equals(this.m_20149_())) {
                        Monitor.disLink(itemStack, player);
                    }
                });
                if (!this.m_9236_().m_5776_()) {
                    this.m_146870_();
                }
            }
        } else if (stack.m_41619_()) {
            int ammo = (Integer)this.f_19804_.m_135370_(AMMO);
            if (ammo > 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentItem.m_41777_());
                this.f_19804_.m_135381_(AMMO, (Object)(ammo - 1));
                if (ammo == 1) {
                    this.f_19804_.m_135381_(DISPLAY_ENTITY, (Object)"");
                    this.f_19804_.m_135381_(MAX_AMMO, (Object)1);
                    this.f_19804_.m_135381_(IS_KAMIKAZE, (Object)false);
                    this.currentItem = ItemStack.f_41583_;
                }
            }
        } else {
            String itemID = DroneEntity.getItemId(stack);
            DroneAttachmentData attachmentData = (DroneAttachmentData)CustomData.DRONE_ATTACHMENT.get(itemID);
            if (attachmentData != null && (Integer)this.f_19804_.m_135370_(AMMO) < attachmentData.count()) {
                if (((String)this.f_19804_.m_135370_(DISPLAY_ENTITY)).equals(attachmentData.displayEntity()) && ItemStack.m_41728_((ItemStack)this.currentItem, (ItemStack)stack.m_255036_(1))) {
                    this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.f_19804_.m_135370_(AMMO) + 1));
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                } else if ((Integer)this.f_19804_.m_135370_(AMMO) == 0) {
                    this.currentItem = stack.m_255036_(1);
                    this.f_19804_.m_135381_(DISPLAY_ENTITY, (Object)attachmentData.displayEntity());
                    this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.f_19804_.m_135370_(AMMO) + 1));
                    this.f_19804_.m_135381_(IS_KAMIKAZE, (Object)attachmentData.isKamikaze);
                    this.f_19804_.m_135381_(MAX_AMMO, (Object)attachmentData.count());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                    float[] scale = attachmentData.scale();
                    float[] offset = attachmentData.offset();
                    float[] rotation = attachmentData.rotation();
                    if (attachmentData.displayData() != null) {
                        this.f_19804_.m_135381_(DISPLAY_ENTITY_TAG, (Object)TagDataParser.parse(attachmentData.displayData(), name -> {
                            UUID uuid = player.m_20148_();
                            return switch (name) {
                                case "@sbw:owner" -> NbtUtils.m_129226_((UUID)uuid);
                                case "@sbw:owner_string_lower" -> StringTag.m_129297_((String)uuid.toString().replace("-", "").toLowerCase(Locale.ROOT));
                                case "@sbw:owner_string_upper" -> StringTag.m_129297_((String)uuid.toString().replace("-", "").toUpperCase(Locale.ROOT));
                                default -> StringTag.m_129297_((String)name);
                            };
                        }));
                    }
                    this.f_19804_.m_135381_(DISPLAY_DATA, List.of(Float.valueOf(scale[0]), Float.valueOf(scale[1]), Float.valueOf(scale[2]), Float.valueOf(offset[0]), Float.valueOf(offset[1]), Float.valueOf(offset[2]), Float.valueOf(rotation[0]), Float.valueOf(rotation[1]), Float.valueOf(rotation[2]), Float.valueOf(attachmentData.xLength), Float.valueOf(attachmentData.zLength), Float.valueOf(attachmentData.tickCount)));
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    @Override
    public void travel() {
        ItemStack stack;
        if (!this.m_20096_()) {
            if (this.rightInputDown) {
                ++this.holdTickX;
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else if (this.leftInputDown) {
                ++this.holdTickX;
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else {
                this.holdTickX = 0;
            }
            if (this.forwardInputDown) {
                ++this.holdTickZ;
                this.f_19804_.m_135381_(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_X_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else if (this.backInputDown) {
                ++this.holdTickZ;
                this.f_19804_.m_135381_(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_X_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else {
                this.holdTickZ = 0;
            }
            this.m_20256_(this.m_20184_().m_82542_(0.965, 0.7, 0.965));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.8, 1.0, 0.8));
            this.setZRot(this.roll * 0.7f);
            this.m_146926_(this.m_146909_() * 0.7f);
            this.setBodyXRot(this.getBodyPitch() * 0.7f);
        }
        if (this.m_20069_() && this.f_19797_ % 4 == 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), 26.0f + (float)(60.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        boolean up = this.upInputDown;
        boolean down = this.downInputDown;
        if (up) {
            ++this.holdTickY;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.01f * (float)Math.min((int)this.holdTickY, (int)5)), (float)0.2f)));
            this.m_20256_(new Vec3(this.m_20184_().f_82479_, 0.05 * (double)this.holdTickY, this.m_20184_().f_82481_));
        } else if (down) {
            ++this.holdTickY;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.02f * (float)Math.min((int)this.holdTickY, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.06f))));
            this.m_20256_(new Vec3(this.m_20184_().f_82479_, -0.05 * (double)this.holdTickY, this.m_20184_().f_82481_));
        } else {
            this.holdTickY = 0;
        }
        if (!up && !down) {
            if (this.m_20184_().m_7098_() < 0.0) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.005f), (float)0.2f)));
            } else {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (this.m_20096_() ? 5.0E-4f : 0.005f)), (float)0.02f)));
            }
        }
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.7f));
        this.f_19804_.m_135381_(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_X_ROT)).floatValue() * 0.7f));
        this.setZRot(Mth.m_14036_((float)(this.getRoll() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.setBodyXRot(Mth.m_14036_((float)(this.getBodyPitch() - ((Float)this.f_19804_.m_135370_(DELTA_X_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.6, 0.0));
        Vector3f direction = this.getRightDirection().mul(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue());
        this.m_20256_(this.m_20184_().m_82549_(new Vec3((double)direction.x, (double)direction.y, (double)direction.z).m_82490_(0.017)));
        Vector3f directionZ = this.getForwardDirection().mul(-((Float)this.f_19804_.m_135370_(DELTA_X_ROT)).floatValue());
        this.m_20256_(this.m_20184_().m_82549_(new Vec3((double)directionZ.x, (double)directionZ.y, (double)directionZ.z).m_82490_(0.017)));
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (controller != null && (stack = controller.m_21205_()).m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using")) {
            this.m_146922_(this.m_146908_() + 0.5f * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue());
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + 0.5f * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue()), (float)-10.0f, (float)90.0f));
        }
        float f = 0.7f;
        AABB aabb = AABB.m_165882_((Vec3)this.m_146892_(), (double)f, (double)0.3, (double)f);
        Level level = this.m_9236_();
        for (Entity target : level.m_6443_(Entity.class, aabb, e -> true)) {
            if (this == target || target == null || target instanceof ItemEntity || target instanceof Projectile || target instanceof ProjectileEntity || target instanceof LaserEntity || target.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || target instanceof AreaEffectCloud || target instanceof C4Entity) continue;
            this.hitEntityCrash(controller, target);
        }
    }

    public void hitEntityCrash(Player player, Entity target) {
        if (this.lastTickSpeed > 0.12) {
            String attachedEntity = (String)this.f_19804_.m_135370_(DISPLAY_ENTITY);
            if (!attachedEntity.isEmpty() && 20.0 * this.lastTickSpeed > (double)this.getHealth()) {
                DroneAttachmentData data = (DroneAttachmentData)CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
                if (data != null) {
                    if (data.isKamikaze) {
                        EntityType.m_20632_((String)attachedEntity).ifPresent(entityType -> {
                            Entity bomb = entityType.m_20615_(this.m_9236_());
                            DamageHandler.doDamage(target, ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), bomb, (Entity)player), data.hitDamage);
                            target.f_19802_ = 0;
                        });
                    } else {
                        DamageHandler.doDamage(target, ModDamageTypes.causeDroneHitDamage(this.m_9236_().m_9598_(), this, (Entity)player), (float)(5.0 * this.lastTickSpeed));
                    }
                }
                if (player != null && player.m_21205_().m_150930_((Item)ModItems.MONITOR.get())) {
                    Monitor.disLink(player.m_21205_(), player);
                }
            }
            this.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_), (Entity)Objects.requireNonNullElse(player, this)), (float)((double)(!((String)this.f_19804_.m_135370_(DISPLAY_ENTITY)).isEmpty() ? 20 : 4) * this.lastTickSpeed));
        }
    }

    @Override
    public boolean engineRunning() {
        return (double)Math.abs((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.05;
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.DRONE_SOUND.get();
    }

    @Override
    public float getEngineSoundVolume() {
        if ((double)Math.abs((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) <= 0.05) {
            return 0.0f;
        }
        Player player = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (player == null) {
            return ((Float)this.f_19804_.m_135370_(POWER)).floatValue();
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
            return ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.25f;
        }
        return ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 2.0f;
    }

    @Override
    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (this.lastTickSpeed < 0.2 || this.collisionCoolDown > 0) {
            return;
        }
        if (this.f_19863_ && Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) > 1.0f) {
            this.m_6469_(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), this, controller == null ? this : controller), (float)(20.0 * ((double)(Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) - 1.0f) * (this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
        if (this.f_19862_) {
            this.m_6469_(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), this, controller == null ? this : controller), (float)(10.0 * ((this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
    }

    static String getItemId(ItemStack stack) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return "";
        }
        return key.toString();
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.DRONE.get());
    }

    @Override
    public void destroy() {
        UUID uuid;
        DroneAttachmentData data;
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (controller != null && controller.m_21205_().m_150930_((Item)ModItems.MONITOR.get())) {
            Monitor.disLink(controller.m_21205_(), controller);
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, Level.ExplosionInteraction.NONE);
        }
        if ((data = (DroneAttachmentData)CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem))) != null) {
            if (data.isKamikaze) {
                this.kamikazeExplosion();
            } else if (this.m_9236_() instanceof ServerLevel) {
                int count = (Integer)this.f_19804_.m_135370_(AMMO);
                for (int i = 0; i < count; ++i) {
                    this.droneDrop(controller);
                }
            }
        }
        String id = (String)this.f_19804_.m_135370_(CONTROLLER);
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            this.m_146870_();
            return;
        }
        Player player = this.m_9236_().m_46003_(uuid);
        if (player != null) {
            player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() == ModItems.MONITOR.get()).forEach(stack -> {
                if (stack.m_41784_().m_128461_("LinkedDrone").equals(this.m_20149_())) {
                    Monitor.disLink(stack, player);
                }
            });
        }
        super.destroy();
    }

    private void kamikazeExplosion() {
        Entity attacker = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        assert (controller != null);
        String attachedEntity = (String)this.f_19804_.m_135370_(DISPLAY_ENTITY);
        if (attachedEntity.isEmpty()) {
            return;
        }
        DroneAttachmentData data = (DroneAttachmentData)CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
        if (data == null) {
            return;
        }
        Entity bomb = EntityType.m_20632_((String)attachedEntity).map(entityType -> entityType.m_20615_(this.m_9236_())).orElse(null);
        if (bomb == null) {
            return;
        }
        this.createCustomExplosion().source(bomb).attacker(attacker).damage(data.explosionDamage).radius(data.explosionRadius).causeVanillaExplosion().withParticleType(ParticleTool.ParticleType.HUGE).explode();
    }

    private void createAreaCloud(Potion potion, Level level, int duration, float radius) {
        if (potion == Potions.f_43598_) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, this.m_20185_() + 0.75 * this.m_20184_().f_82479_, this.m_20186_() + 0.5 * (double)this.m_20206_() + 0.75 * this.m_20184_().f_82480_, this.m_20189_() + 0.75 * this.m_20184_().f_82481_);
        cloud.m_19722_(potion);
        cloud.m_19734_(duration);
        cloud.m_19712_(radius);
        Player controller = EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
        if (controller != null) {
            cloud.m_19718_((LivingEntity)controller);
        }
        level.m_7967_((Entity)cloud);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean canCrushEntities() {
        return false;
    }

    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19855_, (double)this.m_20186_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)((double)(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)((double)Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return new Vec2((float)((double)this.getRotY(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getRotX(partialTicks) + ClientMouseHandler.freeCameraPitch));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        Matrix4f transform = this.getClientVehicleTransform(partialTicks);
        Vector4f maxCameraPosition = this.transformPosition(transform, 0.0f, 0.75f, -2.0f - 0.2f * (float)ClientMouseHandler.custom3pDistanceLerp);
        return CameraTool.getMaxZoom(transform, maxCameraPosition);
    }

    public Entity getController() {
        return EntityFindUtil.findPlayer(this.m_9236_(), (String)this.f_19804_.m_135370_(CONTROLLER));
    }
}

