/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.RemoteControllableTurret;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.item.common.ammo.MortarShell;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarEntity
extends VehicleEntity
implements GeoEntity,
RemoteControllableTurret,
ArtilleryEntity {
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> INTELLIGENT = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DEPRESSED = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Vector3f> TARGET_POS = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity shooter = null;

    public MortarEntity(PlayMessages.SpawnEntity packet, Level level) {
        this((EntityType<MortarEntity>)((EntityType)ModEntities.MORTAR.get()), level);
    }

    public MortarEntity(EntityType<MortarEntity> type, Level level) {
        super(type, level);
    }

    public MortarEntity(Level level, float yRot) {
        super((EntityType)ModEntities.MORTAR.get(), level);
        this.m_146922_(yRot);
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yRot));
    }

    @Override
    public boolean shouldSendHitParticles() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(-70.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(DEPRESSED, (Object)false);
        this.f_19804_.m_135372_(INTELLIGENT, (Object)false);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new Vector3f());
        this.f_19804_.m_135372_(RADIUS, (Object)0);
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    protected float m_6380_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return 0.2f;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Pitch", ((Float)this.f_19804_.m_135370_(PITCH)).floatValue());
        compound.m_128350_("Yaw", ((Float)this.f_19804_.m_135370_(YAW)).floatValue());
        compound.m_128379_("Intelligent", ((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue());
        compound.m_128379_("Depressed", ((Boolean)this.f_19804_.m_135370_(DEPRESSED)).booleanValue());
        compound.m_128405_("Radius", ((Integer)this.f_19804_.m_135370_(RADIUS)).intValue());
        compound.m_128350_("TargetX", ((Vector3f)this.f_19804_.m_135370_(MortarEntity.TARGET_POS)).x);
        compound.m_128350_("TargetY", ((Vector3f)this.f_19804_.m_135370_(MortarEntity.TARGET_POS)).y);
        compound.m_128350_("TargetZ", ((Vector3f)this.f_19804_.m_135370_(MortarEntity.TARGET_POS)).z);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Pitch")) {
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(compound.m_128457_("Pitch")));
        }
        if (compound.m_128441_("Yaw")) {
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(compound.m_128457_("Yaw")));
        }
        if (compound.m_128441_("Intelligent")) {
            this.f_19804_.m_135381_(INTELLIGENT, (Object)compound.m_128471_("Intelligent"));
        }
        if (compound.m_128441_("Depressed")) {
            this.f_19804_.m_135381_(DEPRESSED, (Object)compound.m_128471_("Depressed"));
        }
        if (compound.m_128441_("Radius")) {
            this.f_19804_.m_135381_(RADIUS, (Object)compound.m_128451_("Radius"));
        }
        if (compound.m_128441_("TargetX") && compound.m_128441_("TargetY") && compound.m_128441_("TargetZ")) {
            this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f(compound.m_128457_("TargetX"), compound.m_128457_("TargetX"), compound.m_128457_("TargetZ")));
        }
    }

    public void fire(@Nullable LivingEntity shooter) {
        if (!(((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell)) {
            return;
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) != 0) {
            return;
        }
        this.shooter = shooter;
        this.f_19804_.m_135381_(FIRE_TIME, (Object)25);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MORTAR_LOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MORTAR_FIRE.get(), SoundSource.PLAYERS, 8.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MORTAR_DISTANT.get(), SoundSource.PLAYERS, 32.0f, 1.0f);
        }
    }

    @Override
    public boolean canRemoteFire() {
        return this.m_8020_(0).m_41720_() instanceof MortarShell && (Integer)this.m_20088_().m_135370_(FIRE_TIME) == 0;
    }

    @Override
    public void remoteFire(@Nullable Player player) {
        this.fire((LivingEntity)player);
    }

    @Override
    public double minPitch() {
        return 20.0;
    }

    @Override
    public double maxPitch() {
        return 89.0;
    }

    @Override
    public double shootVelocity() {
        return 10.0;
    }

    @Override
    public float projectileGravity() {
        return 0.13f;
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        InteractionResult result = super.m_6096_(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
                return indicator.bind(mainHandItem, player, this);
            }
        }
        if (mainHandItem.m_41720_() instanceof Monitor && player.m_6144_() && !((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            this.f_19804_.m_135381_(INTELLIGENT, (Object)true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (!player.m_7500_()) {
                mainHandItem.m_41774_(1);
            }
        }
        if (mainHandItem.m_204117_(ModTags.Items.CROWBAR)) {
            if (((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && this.m_9236_() instanceof ServerLevel) {
                this.fire((LivingEntity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_41720_() instanceof MortarShell && !player.m_6144_() && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && ((ItemStack)this.items.get(0)).m_41619_()) {
            this.items.set(0, (Object)mainHandItem.m_255036_(1));
            if (!player.m_7500_()) {
                mainHandItem.m_41774_(1);
            }
            this.fire((LivingEntity)player);
        }
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21205_(), (Entity)player);
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21205_(), (Entity)player);
        }
        if (player.m_6144_()) {
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(player.m_146908_()));
        }
        return InteractionResult.FAIL;
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
        if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            list.add(new ItemStack((ItemLike)ModItems.MONITOR.get()));
        }
        return list;
    }

    @Override
    public void setTarget(ItemStack stack, Entity entity) {
        double targetX = stack.m_41784_().m_128459_("TargetX");
        double targetY = stack.m_41784_().m_128459_("TargetY") - 1.0;
        double targetZ = stack.m_41784_().m_128459_("TargetZ");
        boolean canAim = true;
        this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.f_19804_.m_135381_(DEPRESSED, (Object)stack.m_41784_().m_128471_("IsDepressed"));
        this.f_19804_.m_135381_(RADIUS, (Object)stack.m_41784_().m_128451_("Radius"));
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.shootVelocity(), this.projectileGravity(), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        Vec3 launchVector2 = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.shootVelocity(), this.projectileGravity(), (Boolean)this.f_19804_.m_135370_(DEPRESSED) == false);
        MutableComponent component = Component.m_237113_((String)"");
        MutableComponent location = Component.m_237110_((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.m_5446_()}).m_7220_((Component)Component.m_237113_((String)(" X:" + FormatTool.format0D(this.m_20185_()) + " Y:" + FormatTool.format0D(this.m_20186_()) + " Z:" + FormatTool.format0D(this.m_20189_()) + " ")));
        float angle = this.m_146909_();
        if (launchVector == null || launchVector2 == null) {
            canAim = false;
            component = Component.m_237115_((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            angle = (float)(-MortarEntity.getXRotFromVector(launchVector));
            float angle2 = (float)(-MortarEntity.getXRotFromVector(launchVector2));
            if ((double)angle < -this.maxPitch() || (double)angle > -this.minPitch()) {
                if ((double)angle2 > -this.maxPitch() && (double)angle2 < -this.minPitch()) {
                    component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn2");
                    canAim = false;
                } else {
                    component = Component.m_237110_((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.m_5446_()});
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
            }
            if ((double)angle < -this.maxPitch()) {
                component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn");
                canAim = false;
            }
        }
        if (canAim) {
            this.look(randomPos);
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(angle));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
        }
    }

    @Override
    public void resetTarget() {
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.shootVelocity(), this.projectileGravity(), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        this.look(randomPos);
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-MortarEntity.getXRotFromVector(launchVector));
        if ((double)angle > -this.maxPitch() && (double)angle < -this.minPitch()) {
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(angle));
        }
    }

    @Override
    public void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)this);
        double d0 = (pTarget.f_82479_ - vec3.f_82479_) * 0.2;
        double d2 = (pTarget.f_82481_ - vec3.f_82481_) * 0.2;
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        Level level;
        super.m_6075_();
        int fireTime = (Integer)this.f_19804_.m_135370_(FIRE_TIME);
        if (fireTime > 0) {
            this.f_19804_.m_135381_(FIRE_TIME, (Object)(fireTime - 1));
        }
        if (fireTime == 5 && ((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            MortarShellEntity entityToSpawn = MortarShell.createShell(this.shooter, level, (ItemStack)this.items.get(0));
            entityToSpawn.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            entityToSpawn.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, (float)this.shootVelocity(), 0.1f);
            level.m_7967_((Entity)entityToSpawn);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + 3.0 * this.m_20154_().f_82479_, this.m_20186_() + 0.1 + 3.0 * this.m_20154_().f_82480_, this.m_20189_() + 3.0 * this.m_20154_().f_82481_, 8, 0.4, 0.4, 0.4, 0.007);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 50, 2.0, 0.02, 2.0, 5.0E-4);
            this.m_6211_();
            if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
                this.resetTarget();
            }
            ShakeClientMessage.sendToNearbyPlayers(this, 6.0, 6.0, 8.0, 14.0);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    @Override
    public void travel() {
        float diffY = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(YAW)).floatValue() - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(PITCH)).floatValue() - this.m_146909_()));
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-20.0f, (float)20.0f));
        this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)(0.5f * diffX), (float)-20.0f, (float)20.0f)), (float)-89.0f, (float)-20.0f));
    }

    private PlayState movementPredicate(AnimationState<MortarEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.idle"));
    }

    @Override
    public void destroy() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            level2.m_254849_(null, x, y, z, 0.0f, Level.ExplosionInteraction.NONE);
            ItemEntity mortar = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
            mortar.m_32010_(10);
            level2.m_7967_((Entity)mortar);
            if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
                ItemEntity monitor = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MONITOR.get()));
                monitor.m_32010_(10);
                level2.m_7967_((Entity)monitor);
            }
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public void m_6596_() {
        if (!((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            this.fire(null);
        }
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get());
    }

    @Override
    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return super.m_7013_(slot, stack) && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && stack.m_41720_() instanceof MortarShell;
    }

    @Override
    public int getMaxPassengers() {
        return 0;
    }
}

