/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Comparator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface AutoAimable {
    default public Entity seekNearLivingEntity(Entity attacker, Vec3 pos, double minAngle, double maxAngle, double minRange, double seekRange, double size) {
        for (Entity target : attacker.m_9236_().m_6443_(Entity.class, new AABB(pos, pos).m_82400_(seekRange), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(pos))).toList()) {
            LivingEntity living;
            Player player;
            boolean condition = target.m_20280_(attacker) > minRange * minRange && target.m_20280_(attacker) <= seekRange * seekRange && AutoAimable.canAim(pos, target, minAngle, maxAngle) && VehicleEntity.getSubmergedHeight(target) <= (double)target.m_20206_() && this.checkNoClip(attacker, target, pos) && (!(target instanceof Player) || !(player = (Player)target).m_5833_() && !player.m_7500_()) && (target instanceof LivingEntity && (living = (LivingEntity)target) instanceof Enemy && living.m_21223_() > 0.0f || this.isThreateningEntity(attacker, target, size, pos) || this.basicEnemyFilter(target)) && SeekTool.smokeFilter(target);
            if (!condition) continue;
            return target;
        }
        return null;
    }

    default public boolean isThreateningEntity(Entity attacker, Entity target, double size, Vec3 pos) {
        if (target instanceof SmallCannonShellEntity) {
            return false;
        }
        if (!target.m_20096_() && target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if (((double)target.m_20205_() >= size || (double)target.m_20206_() >= size) && VectorTool.calculateAngle(target.m_20184_().m_82541_(), target.m_20182_().m_82505_(attacker.m_20182_()).m_82541_()) < 30.0) {
                return this.checkNoClip(attacker, target, pos) && this.basicEnemyProjectileFilter(projectile);
            }
        }
        return false;
    }

    default public boolean checkNoClip(Entity attacker, Entity target, Vec3 pos) {
        return attacker.m_9236_().m_45547_(new ClipContext(pos, target.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, attacker)).m_6662_() != HitResult.Type.BLOCK;
    }

    public boolean basicEnemyFilter(Entity var1);

    public boolean basicEnemyProjectileFilter(Projectile var1);

    public static boolean canAim(Vec3 pos, Entity target, double minAngle, double maxAngle) {
        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
        Vec3 toVec = pos.m_82505_(targetPos).m_82541_();
        double targetAngle = VehicleEntity.getXRotFromVector(toVec);
        return minAngle < targetAngle && targetAngle < maxAngle;
    }
}

