/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.api.event.ReloadEvent;
import com.atsuishio.superbwarfare.config.server.ProjectileConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.GrapeshotEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class CustomEventHandler {
    @SubscribeEvent
    public static void onPreReload(ReloadEvent.Pre event) {
        Entity shooter = event.shooter;
        ItemStack stack = event.stack;
        if (shooter == null || !(stack.m_41720_() instanceof GunItem) || shooter.m_9236_().f_46443_) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().preReload(data, instance, shooter);
        }
    }

    @SubscribeEvent
    public static void onPostReload(ReloadEvent.Post event) {
        Entity shooter = event.shooter;
        ItemStack stack = event.stack;
        if (shooter == null || !(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (shooter.m_9236_().f_46443_) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().postReload(data, instance, shooter);
        }
    }

    @SubscribeEvent
    public static void onProjectileHitEntity(ProjectileHitEvent.HitEntity event) {
        Entity entity = event.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack stack = attacker.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        Projectile projectile = event.getProjectile();
        GunData data = GunData.from(stack);
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)projectile.m_6095_());
        if (key == null) {
            return;
        }
        if (!data.get(GunProp.PROJECTILE).type.equals(key.toString())) {
            return;
        }
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().onHit(attacker, data, instance, event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onProjectileHitBlock(ProjectileHitEvent.HitBlock event) {
        Projectile projectile = event.getProjectile();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        Block block = state.m_60734_();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            if (projectile instanceof ProjectileEntity || projectile instanceof GrapeshotEntity) {
                bell.m_49712_(projectile.m_9236_(), pos, face);
            }
        }
        if (projectile instanceof ProjectileEntity) {
            ProjectileEntity p = (ProjectileEntity)projectile;
            if (((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get()).booleanValue() && state.m_204336_(ModTags.Blocks.BULLET_CAN_DESTROY)) {
                p.m_9236_().m_46953_(pos, false, p.getShooter());
            }
            if (state.m_60734_() instanceof TargetBlock) {
                p.recordHitScore(face, event.getHitVec());
            }
        }
        if (projectile instanceof GrapeshotEntity) {
            GrapeshotEntity grapeshotEntity = (GrapeshotEntity)projectile;
            if (((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get()).booleanValue() && state.m_204336_(ModTags.Blocks.CANNON_SHOT_CAN_DESTROY)) {
                grapeshotEntity.m_9236_().m_46953_(pos, false, grapeshotEntity.m_19749_());
            }
        }
    }
}

