/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.config.server.SpawnConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.mob_guns.MobGunData;
import com.atsuishio.superbwarfare.entity.goal.GunShootGoal;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="superbwarfare")
public class EntityUseGunEventHandler {
    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        if (event.loadedFromDisk() || !((Boolean)SpawnConfig.SPAWN_MOB_WITH_GUNS.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        MobGunData data = MobGunData.from(mob);
        if (data == null || data.probability() <= 0.0 || data.probability() < entity.m_9236_().f_46441_.m_188500_()) {
            return;
        }
        GunData gunData = data.getGunData();
        if (gunData == null) {
            return;
        }
        mob.f_21345_.m_25352_(data.goalWeight(), new GunShootGoal<Mob>(mob, data));
        if (data.backupAmmoCount() > 0) {
            gunData.virtualAmmo.set(data.backupAmmoCount());
        }
        if (data.spawnWithLoadedAmmo()) {
            gunData.reloadAmmo((Entity)mob);
        }
        mob.m_21008_(InteractionHand.MAIN_HAND, gunData.stack);
    }
}

