/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.BocekItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.BocekImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class BocekItem
extends GunItem {
    public BocekItem() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return BocekItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        if (ClientEventHandler.bowPull) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bocek.pull"));
        }
        if (player.m_20142_() && player.m_20096_() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState firePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        if (GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState reloadPredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
        AnimationController fireController = new AnimationController((GeoAnimatable)this, "fireController", 0, this::firePredicate);
        data.add(new AnimationController[]{fireController});
        AnimationController reloadController = new AnimationController((GeoAnimatable)this, "reloadController", 0, this::reloadPredicate);
        data.add(new AnimationController[]{reloadController});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") > 0) {
            GunsTool.setGunIntTag(stack, "ArrowEmpty", GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") - 1);
        }
    }

    @Override
    public ResourceLocation getGunIcon(ItemStack stack) {
        return Mod.loc("textures/gun_icon/bocek_icon.png");
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new BocekImageComponent(pStack));
    }

    @Override
    public void shoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
        block7: {
            block9: {
                block8: {
                    super.onFireKeyRelease(data, player, power, zoom);
                    if (!data.hasEnoughAmmoToShoot((Entity)player)) {
                        return;
                    }
                    perk = data.perk.get(Perk.Type.AMMO);
                    if (player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_1P.getId(), SoundSource.PLAYERS);
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_3P.getId(), SoundSource.PLAYERS);
                        Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with((Supplier<ServerPlayer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onFireKeyRelease$0(net.minecraft.server.level.ServerPlayer ), ()Lnet/minecraft/server/level/ServerPlayer;)((ServerPlayer)serverPlayer)), (Object)new ShootClientMessage(10.0));
                    }
                    if (!(power * 12.0 >= 6.0)) break block7;
                    if (!zoom) break block8;
                    this.spawnBullet(data, player, power, true);
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_1P.get(), 10.0f, 1.0f);
                    player.m_5496_((SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_3P.get(), 2.0f, 1.0f);
                    break block9;
                }
                i = 0;
                while (true) {
                    if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
                    ammoPerk = (AmmoPerk)perk;
                    if (ammoPerk.slug) {
                        v0 = 1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = 10;
                    }
                    if (i >= v0) break;
                    this.spawnBullet(data, player, power, false);
                    ++i;
                }
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_1P.get(), 10.0f, 1.0f);
                player.m_5496_((SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_3P.get(), 2.0f, 1.0f);
            }
            if (perk == ModPerks.BEAST_BULLET.get()) {
                player.m_5496_((SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                }
            }
            GunsTool.setGunIntTag(data.stack, "ArrowEmpty", 7);
            data.ammo.set(data.ammo.get() - data.get(GunProp.AMMO_COST_PER_SHOOT));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void spawnBullet(GunData data, Player player, double power, boolean zoom) {
        block6: {
            block5: {
                stack = data.stack;
                perk = data.perk.get(Perk.Type.AMMO);
                headshot = data.get(GunProp.HEADSHOT).floatValue();
                velocity = (float)(24.0 * power);
                bypassArmorRate = data.get(GunProp.BYPASSES_ARMOR).floatValue();
                if (!zoom) break block5;
                spread = 0.01f;
                damage = 0.08333333 * data.get(GunProp.DAMAGE) * 12.0 * power * BocekItem.perkDamage(perk);
                break block6;
            }
            if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                v0 = 0.5f;
            } else lbl-1000:
            // 2 sources

            {
                v0 = spread = 2.5f;
            }
            if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                v1 = 0.08333333;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 0.008333333;
            }
            damage = v1 * data.get(GunProp.DAMAGE) * 12.0 * power * BocekItem.perkDamage(perk);
        }
        projectile = new ProjectileEntity(player.m_9236_()).shooter((Entity)player).headShot(headshot).zoom(zoom).bypassArmorRate(bypassArmorRate).setGunItemId(stack);
        for (Perk.Type type : Perk.Type.values()) {
            instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, (Entity)projectile);
        }
        projectile.m_6034_(player.m_20185_() - 0.1 * player.m_20154_().f_82479_, player.m_20188_() - 0.1 - 0.1 * player.m_20154_().f_82480_, player.m_20189_() + -0.1 * player.m_20154_().f_82481_);
        projectile.shoot(player, player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_, (zoom == false && perk == ModPerks.INCENDIARY_BULLET.get() ? 0.2f : 1.0f) * velocity, spread);
        projectile.damage((float)damage);
        player.m_9236_().m_7967_((Entity)projectile);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IClientItemExtensions getClientExtensions() {
        return new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer;
            {
                this.renderer = (BlockEntityWithoutLevelRenderer)BocekItem.this.getRenderer().get();
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        };
    }

    private static /* synthetic */ ServerPlayer lambda$onFireKeyRelease$0(ServerPlayer serverPlayer) {
        return serverPlayer;
    }
}

