/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.menu.EnergyMenu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import com.atsuishio.superbwarfare.network.dataslot.SimpleEnergyData;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuCloseMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuOpenMessage;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FuMO25Menu
extends EnergyMenu {
    protected final Container container;
    protected final ContainerLevelAccess access;
    protected final ContainerEnergyData containerData;
    private int posX = Integer.MIN_VALUE;
    private int posY = Integer.MIN_VALUE;
    private int posZ = Integer.MIN_VALUE;
    public static final int X_OFFSET = 164;
    public static final int Y_OFFSET = 0;

    public FuMO25Menu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(1), ContainerLevelAccess.f_39287_, new SimpleEnergyData(5));
    }

    public FuMO25Menu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access, ContainerEnergyData containerData) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(1), access, containerData);
    }

    public FuMO25Menu(int pContainerId, Inventory inventory, Container container, ContainerLevelAccess access, ContainerEnergyData containerData) {
        super((MenuType)ModMenuTypes.FUMO_25_MENU.get(), pContainerId, containerData);
        FuMO25Menu.m_38869_((Container)container, (int)1);
        this.container = container;
        this.access = access;
        this.containerData = containerData;
        this.m_38897_(new ParaSlot(container, 0, 278, 60));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18 + 164, 84 + i * 18 + 0));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18 + 164, 142));
        }
    }

    public void setPos(int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void resetPos() {
        this.posX = Integer.MIN_VALUE;
        this.posY = Integer.MIN_VALUE;
        this.posZ = Integer.MIN_VALUE;
    }

    public void setPosToParameters() {
        if (this.posX != Integer.MIN_VALUE && this.posY != Integer.MIN_VALUE) {
            ItemStack stack = this.container.m_8020_(0);
            if (stack.m_41619_()) {
                return;
            }
            stack.m_41784_().m_128405_("TargetX", this.posX);
            stack.m_41784_().m_128405_("TargetY", this.posY);
            stack.m_41784_().m_128405_("TargetZ", this.posZ);
            this.resetPos();
            this.container.m_6596_();
        }
    }

    public void setTargetToLaserTower() {
    }

    @Nullable
    public BlockPos getCurrentPos() {
        if (this.posX != Integer.MIN_VALUE && this.posY != Integer.MIN_VALUE && this.posZ != Integer.MIN_VALUE) {
            return new BlockPos(this.posX, this.posY, this.posZ);
        }
        return null;
    }

    public Optional<BlockPos> getSelfPos() {
        return this.access.m_6721_((level, pos) -> pos);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex != 0) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (pIndex >= 1 && pIndex < 28 ? !this.m_38903_(itemstack1, 28, 37, false) : pIndex >= 28 && pIndex < 37 && !this.m_38903_(itemstack1, 1, 28, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, 1, 37, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60713_((Block)ModBlocks.FUMO_25.get()) && pPlayer.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public void m_6877_(Player pPlayer) {
        this.access.m_39292_((level, pos) -> {
            ItemStack para = this.container.m_8020_(0);
            if (!para.m_41619_()) {
                pPlayer.m_150109_().m_150079_(para);
            }
            this.container.m_8016_(0);
            this.resetPos();
        });
    }

    public long getEnergy() {
        return this.containerData.get(0);
    }

    public long getFuncType() {
        return this.containerData.get(1);
    }

    public void setFuncTypeAndTime(byte type) {
        this.containerData.set(1, type);
        int tick = switch (type) {
            case 1, 2 -> 1200;
            case 3 -> 600;
            default -> 0;
        };
        this.containerData.set(2, tick);
    }

    public long getTime() {
        return this.containerData.get(2);
    }

    public boolean isPowered() {
        return this.containerData.get(3) == 1L;
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof FuMO25Menu) {
            FuMO25Menu fuMO25Menu = (FuMO25Menu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                fuMO25Menu.getSelfPos().ifPresent(pos -> Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RadarMenuOpenMessage((BlockPos)pos)));
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        Player player;
        if (event.getContainer() instanceof FuMO25Menu && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)RadarMenuCloseMessage.INSTANCE);
        }
    }

    static class ParaSlot
    extends Slot {
        public ParaSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return pStack.m_150930_((Item)ModItems.FIRING_PARAMETERS.get());
        }
    }
}

