/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mobeffect;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BurnMobEffect
extends MobEffect {
    public BurnMobEffect() {
        super(MobEffectCategory.HARMFUL, -12708330);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Entity attacker = !entity.getPersistentData().m_128441_("BurnAttacker") ? null : entity.m_9236_().m_6815_(entity.getPersistentData().m_128451_("BurnAttacker"));
        DamageHandler.doDamage((Entity)entity, ModDamageTypes.causeBurnDamage(entity.m_9236_().m_9598_(), attacker), 0.6f + 0.3f * (float)amplifier);
        entity.f_19802_ = 0;
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (!instance.m_19544_().equals(ModMobEffects.BURN.get())) {
            return;
        }
        DamageHandler.doDamage((Entity)living, new DamageSource((Holder)living.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268631_), event.getEffectSource()), 0.6f + 0.3f * (float)instance.m_19564_());
        living.f_19802_ = 0;
        Entity entity = event.getEffectSource();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            living.getPersistentData().m_128405_("BurnAttacker", source.m_19879_());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.m_19544_().equals(ModMobEffects.BURN.get())) {
            living.getPersistentData().m_128473_("BurnAttacker");
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.m_19544_().equals(ModMobEffects.BURN.get())) {
            living.getPersistentData().m_128473_("BurnAttacker");
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_21023_((MobEffect)ModMobEffects.BURN.get())) {
            living.m_7311_(2);
        }
        if (living.m_20069_()) {
            living.m_21195_((MobEffect)ModMobEffects.BURN.get());
        }
    }
}

