/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record PlayerGunKillMessage(int attackerId, int targetId, boolean headshot, ResourceKey<DamageType> damageType) {
    public static void encode(PlayerGunKillMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.attackerId);
        buffer.writeInt(message.targetId);
        buffer.writeBoolean(message.headshot);
        buffer.m_236858_(message.damageType);
    }

    public static PlayerGunKillMessage decode(FriendlyByteBuf buffer) {
        int attackerId = buffer.readInt();
        int targetId = buffer.readInt();
        boolean headshot = buffer.readBoolean();
        ResourceKey damageType = buffer.m_236801_(Registries.f_268580_);
        return new PlayerGunKillMessage(attackerId, targetId, headshot, (ResourceKey<DamageType>)damageType);
    }

    public static void handler(PlayerGunKillMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                Player player = level.m_6815_(message.attackerId) instanceof Player ? (Player)level.m_6815_(message.attackerId) : null;
                Entity target = level.m_6815_(message.targetId);
                if (player != null && target != null) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PlayerGunKillMessage.lambda$handler$1(player, target, message, (Supplier)ctx));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handler$1(Player player, Entity target, PlayerGunKillMessage message, Supplier ctx) {
        return () -> PlayerGunKillMessage.lambda$handler$0(player, target, message, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handler$0(Player player, Entity target, PlayerGunKillMessage message, Supplier ctx) {
        ClientPacketHandler.handlePlayerKillMessage(player, target, message.headshot, message.damageType, ctx);
    }
}

