/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;

public class DroneFireMessage {
    private final Vector3f pos;

    public DroneFireMessage(Vector3f pos) {
        this.pos = pos;
    }

    public static DroneFireMessage decode(FriendlyByteBuf buffer) {
        return new DroneFireMessage(buffer.m_269394_());
    }

    public static void encode(DroneFireMessage message, FriendlyByteBuf buffer) {
        buffer.m_269582_(message.pos);
    }

    public static void handler(DroneFireMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DroneEntity drone;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked") && (drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"))) != null) {
                if (player.m_21206_().m_150930_((Item)ModItems.FIRING_PARAMETERS.get()) || player.m_21206_().m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                    ItemStack offStack = player.m_21206_();
                    offStack.m_41784_().m_128347_("TargetX", (double)message.pos.x());
                    offStack.m_41784_().m_128347_("TargetY", (double)message.pos.y());
                    offStack.m_41784_().m_128347_("TargetZ", (double)message.pos.z());
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.mortar.target_pos").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("[" + offStack.m_41784_().m_128451_("TargetX") + "," + offStack.m_41784_().m_128451_("TargetY") + "," + offStack.m_41784_().m_128451_("TargetZ") + "]"))), true);
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
                    Item patt2891$temp = offStack.m_41720_();
                    if (patt2891$temp instanceof ArtilleryIndicator) {
                        ArtilleryIndicator indicator = (ArtilleryIndicator)patt2891$temp;
                        indicator.setTarget(offStack, (Player)player);
                    }
                } else {
                    drone.fire = true;
                }
            }
        });
        context.setPacketHandled(true);
    }
}

