/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ShootMessage {
    private final double spread;
    private final boolean zoom;
    @Nullable
    private final UUID uuid;

    public ShootMessage(double spread, boolean zoom, @Nullable UUID uuid) {
        this.spread = spread;
        this.zoom = zoom;
        this.uuid = uuid;
    }

    public static ShootMessage decode(FriendlyByteBuf buffer) {
        return new ShootMessage(buffer.readDouble(), buffer.readBoolean(), buffer.m_236860_(FriendlyByteBuf::m_130259_).orElse(null));
    }

    public static void encode(ShootMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.spread);
        buffer.writeBoolean(message.zoom);
        buffer.m_236835_(Optional.ofNullable(message.uuid), FriendlyByteBuf::m_130077_);
    }

    public static void handler(ShootMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                ShootMessage.pressAction((Player)context.getSender(), message.spread, message.zoom, message.uuid);
            }
        });
        context.setPacketHandled(true);
    }

    public static void pressAction(Player player, double spread, boolean zoom, @Nullable UUID uuid) {
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData.from(stack).shoot((Entity)player, spread, zoom, uuid);
    }
}

