/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.track;

import com.happysg.radar.block.monitor.MonitorSprite;
import com.happysg.radar.block.radar.track.RadarTrackUtil;
import com.happysg.radar.block.radar.track.TrackCategory;
import com.happysg.radar.config.RadarConfig;
import net.createmod.catnip.theme.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.core.api.ships.Ship;

public class RadarTrack {
    private final String id;
    private Vec3 position;
    private Vec3 velocity;
    private long scannedTime;
    private final TrackCategory trackCategory;
    private final String entityType;

    public RadarTrack(String id, Vec3 position, Vec3 velocity, long scannedTime, TrackCategory trackCategory, String entityType) {
        this.id = id;
        this.position = position;
        this.velocity = velocity;
        this.scannedTime = scannedTime;
        this.trackCategory = trackCategory;
        this.entityType = entityType;
    }

    public RadarTrack(Entity entity) {
        this(entity.m_20148_().toString(), entity.m_20182_(), entity.m_20184_(), entity.m_9236_().m_46467_(), TrackCategory.get(entity), entity.m_6095_().toString());
    }

    public Color getColor() {
        return switch (this.trackCategory) {
            case TrackCategory.VS2 -> new Color(((Integer)RadarConfig.client().VS2Color.get()).intValue());
            case TrackCategory.CONTRAPTION -> new Color(((Integer)RadarConfig.client().contraptionColor.get()).intValue());
            case TrackCategory.PLAYER -> new Color(((Integer)RadarConfig.client().playerColor.get()).intValue());
            case TrackCategory.ANIMAL -> new Color(((Integer)RadarConfig.client().friendlyColor.get()).intValue());
            case TrackCategory.HOSTILE -> new Color(((Integer)RadarConfig.client().hostileColor.get()).intValue());
            case TrackCategory.PROJECTILE -> new Color(((Integer)RadarConfig.client().projectileColor.get()).intValue());
            default -> Color.WHITE;
        };
    }

    public MonitorSprite getSprite() {
        return switch (this.trackCategory) {
            case TrackCategory.VS2, TrackCategory.CONTRAPTION -> MonitorSprite.CONTRAPTION_HITBOX;
            case TrackCategory.PLAYER -> MonitorSprite.PLAYER;
            case TrackCategory.PROJECTILE -> MonitorSprite.PROJECTILE;
            default -> MonitorSprite.ENTITY_HITBOX;
        };
    }

    public static RadarTrack deserializeNBT(CompoundTag tag) {
        return new RadarTrack(tag.m_128461_("id"), new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z")), new Vec3(tag.m_128459_("vx"), tag.m_128459_("vy"), tag.m_128459_("vz")), tag.m_128454_("scannedTime"), TrackCategory.values()[tag.m_128451_("Category")], tag.m_128461_("entityType"));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        tag.m_128347_("x", this.position.f_82479_);
        tag.m_128347_("y", this.position.f_82480_);
        tag.m_128347_("z", this.position.f_82481_);
        tag.m_128347_("vx", this.velocity.f_82479_);
        tag.m_128347_("vy", this.velocity.f_82480_);
        tag.m_128347_("vz", this.velocity.f_82481_);
        tag.m_128356_("scannedTime", this.scannedTime);
        tag.m_128405_("Category", this.trackCategory.ordinal());
        tag.m_128359_("entityType", this.entityType);
        return tag;
    }

    public void updateRadarTrack(Entity entity) {
        this.position = entity.m_20182_();
        this.velocity = entity.m_20184_();
        this.scannedTime = entity.m_9236_().m_46467_();
    }

    public void updateRadarTrack(Ship ship, Level level) {
        this.position = RadarTrackUtil.getPosition(ship);
        this.velocity = RadarTrackUtil.getVelocity(ship);
        this.scannedTime = level.m_46467_();
    }

    public String getId() {
        return this.id;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vec3 velocity) {
        this.velocity = velocity;
    }

    public long getScannedTime() {
        return this.scannedTime;
    }

    public void setScannedTime(long scannedTime) {
        this.scannedTime = scannedTime;
    }

    public TrackCategory getTrackCategory() {
        return this.trackCategory;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String id() {
        return this.getId();
    }

    public Vec3 position() {
        return this.getPosition();
    }

    public Vec3 velocity() {
        return this.getVelocity();
    }

    public long scannedTime() {
        return this.getScannedTime();
    }

    public TrackCategory trackCategory() {
        return this.getTrackCategory();
    }

    public String entityType() {
        return this.getEntityType();
    }
}

