/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queries.intervals.Intervals;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import java.util.Locale;
import java.util.Objects;

public class Within
extends IntervalFunction {
    private final int positions;
    private final IntervalFunction source;
    private final IntervalFunction reference;

    public Within(IntervalFunction source, int positions, IntervalFunction reference) {
        this.positions = positions;
        this.source = Objects.requireNonNull(source);
        this.reference = Objects.requireNonNull(reference);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.within(this.source.toIntervalSource(field, analyzer), this.positions, this.reference.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:within(%s %d %s)", this.source, this.positions, this.reference);
    }
}

