/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.uhighlight;

import java.text.BreakIterator;
import java.text.CharacterIterator;

public class LengthGoalBreakIterator
extends BreakIterator {
    private final BreakIterator baseIter;
    private final int lengthGoal;
    private final float fragmentAlignment;
    private final boolean isMinimumLength;
    private int currentCache;

    public static LengthGoalBreakIterator createMinLength(BreakIterator baseIter, int minLength, float fragmentAlignment) {
        return new LengthGoalBreakIterator(baseIter, minLength, fragmentAlignment, true, baseIter.current());
    }

    public static LengthGoalBreakIterator createClosestToLength(BreakIterator baseIter, int targetLength, float fragmentAlignment) {
        return new LengthGoalBreakIterator(baseIter, targetLength, fragmentAlignment, false, baseIter.current());
    }

    private LengthGoalBreakIterator(BreakIterator baseIter, int lengthGoal, float fragmentAlignment, boolean isMinimumLength, int currentCache) {
        this.baseIter = baseIter;
        this.currentCache = currentCache;
        this.lengthGoal = lengthGoal;
        if (fragmentAlignment < 0.0f || fragmentAlignment > 1.0f || !Float.isFinite(fragmentAlignment)) {
            throw new IllegalArgumentException("fragmentAlignment must be >= zero and <= one");
        }
        this.fragmentAlignment = fragmentAlignment;
        this.isMinimumLength = isMinimumLength;
    }

    public String toString() {
        String goalDesc = this.isMinimumLength ? "minLen" : "targetLen";
        return this.getClass().getSimpleName() + "{" + goalDesc + "=" + this.lengthGoal + ", fragAlign=" + this.fragmentAlignment + ", baseIter=" + this.baseIter + "}";
    }

    @Override
    public Object clone() {
        return new LengthGoalBreakIterator((BreakIterator)this.baseIter.clone(), this.lengthGoal, this.fragmentAlignment, this.isMinimumLength, this.currentCache);
    }

    @Override
    public CharacterIterator getText() {
        return this.baseIter.getText();
    }

    @Override
    public void setText(String newText) {
        this.baseIter.setText(newText);
        this.currentCache = this.baseIter.current();
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.baseIter.setText(newText);
        this.currentCache = this.baseIter.current();
    }

    @Override
    public int current() {
        return this.currentCache;
    }

    @Override
    public int first() {
        this.currentCache = this.baseIter.first();
        return this.currentCache;
    }

    @Override
    public int last() {
        this.currentCache = this.baseIter.last();
        return this.currentCache;
    }

    @Override
    public int next(int n) {
        assert (false) : "Not supported";
        return this.baseIter.next(n);
    }

    @Override
    public int next() {
        return this.following(this.currentCache, this.currentCache + this.lengthGoal);
    }

    @Override
    public int previous() {
        assert (false) : "Not supported";
        return this.baseIter.previous();
    }

    @Override
    public int following(int matchEndIndex) {
        return this.following(matchEndIndex, matchEndIndex + 1 + (int)((float)this.lengthGoal * (1.0f - this.fragmentAlignment)));
    }

    private int following(int matchEndIndex, int targetIdx) {
        if (targetIdx >= this.getText().getEndIndex()) {
            if (this.currentCache == this.baseIter.last()) {
                return -1;
            }
            this.currentCache = this.baseIter.last();
            return this.currentCache;
        }
        int afterIdx = this.baseIter.following(targetIdx - 1);
        if (afterIdx == -1) {
            this.currentCache = this.baseIter.last();
            return -1;
        }
        if (afterIdx == targetIdx) {
            this.currentCache = afterIdx;
            return this.currentCache;
        }
        if (this.isMinimumLength) {
            this.currentCache = afterIdx;
            return this.currentCache;
        }
        int beforeIdx = this.baseIter.preceding(targetIdx);
        if (targetIdx - beforeIdx < afterIdx - targetIdx && beforeIdx > matchEndIndex) {
            this.currentCache = beforeIdx;
            return this.currentCache;
        }
        this.currentCache = afterIdx;
        return this.currentCache;
    }

    @Override
    public int preceding(int matchStartIndex) {
        int targetIdx = matchStartIndex - 1 - (int)((float)this.lengthGoal * this.fragmentAlignment);
        if (targetIdx <= 0) {
            if (this.currentCache == this.baseIter.first()) {
                return -1;
            }
            this.currentCache = this.baseIter.first();
            return this.currentCache;
        }
        int beforeIdx = this.baseIter.preceding(targetIdx + 1);
        if (beforeIdx == -1) {
            this.currentCache = this.baseIter.first();
            return -1;
        }
        if (beforeIdx == targetIdx) {
            this.currentCache = beforeIdx;
            return this.currentCache;
        }
        if (this.isMinimumLength) {
            this.currentCache = beforeIdx;
            return this.currentCache;
        }
        int afterIdx = this.baseIter.following(targetIdx - 1);
        if (afterIdx - targetIdx < targetIdx - beforeIdx && afterIdx < matchStartIndex) {
            this.currentCache = afterIdx;
            return this.currentCache;
        }
        this.currentCache = beforeIdx;
        return this.currentCache;
    }

    @Override
    public boolean isBoundary(int offset) {
        assert (false) : "Not supported";
        return this.baseIter.isBoundary(offset);
    }
}

