/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.FluidPlacerConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPlacerTile
extends IndustrialAreaWorkingTile<FluidPlacerTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<FluidPlacerTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("input", FluidPlacerConfig.maxInputTankSize, 43, 20, 0).setColor(DyeColor.BLUE).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this);

    public FluidPlacerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FLUID_PLACER, RangeManager.RangeType.BEHIND, false, FluidPlacerConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.getMaxProgress = FluidPlacerConfig.maxProgress;
        this.getPowerPerOperation = FluidPlacerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pointed;
        if (this.hasEnergy(this.getPowerPerOperation) && this.isLoaded(pointed = this.getPointedBlockPos()) && BlockUtils.canBlockBeBroken(this.f_58857_, pointed) && !this.f_58857_.m_6425_(pointed).m_76170_() && this.tank.getFluidAmount() >= 1000) {
            if (this.tank.getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && this.f_58857_.m_8055_(pointed).m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)this.f_58857_.m_8055_(pointed).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.f_58857_.m_46597_(pointed, (BlockState)this.f_58857_.m_8055_(pointed).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                this.tank.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
            if (this.f_58857_.m_46859_(pointed) || !this.f_58857_.m_6425_(pointed).m_76178_() && !this.f_58857_.m_6425_(pointed).m_76170_()) {
                this.f_58857_.m_46597_(pointed, this.tank.getFluid().getFluid().m_76145_().m_76188_());
                this.tank.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<FluidPlacerTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidPlacerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public FluidPlacerTile getSelf() {
        return this;
    }
}

