/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;

public class MCEFSettings {
    private static final Path PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("mcef").resolve("mcef.properties");
    private static int deleteRetries = 0;
    private boolean skipDownload = false;
    private String downloadMirror = "https://mcef-download.cinemamod.com";
    private String userAgent = null;
    private boolean useCache = true;

    public boolean isSkipDownload() {
        return this.skipDownload;
    }

    public void setSkipDownload(boolean skipDownload) {
        this.skipDownload = skipDownload;
        this.saveAsync();
    }

    public String getDownloadMirror() {
        return this.downloadMirror;
    }

    public void setDownloadMirror(String downloadMirror) {
        this.downloadMirror = downloadMirror;
        this.saveAsync();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.saveAsync();
    }

    public boolean isUsingCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
        this.saveAsync();
    }

    public void saveAsync() {
        CompletableFuture.runAsync(() -> {
            try {
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void save() throws IOException {
        File file = PATH.toFile();
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        Properties properties = new Properties();
        properties.setProperty("skip-download", String.valueOf(this.skipDownload));
        properties.setProperty("download-mirror", String.valueOf(this.downloadMirror));
        properties.setProperty("user-agent", String.valueOf(this.userAgent));
        properties.setProperty("use-cache", String.valueOf(this.useCache));
        try (FileOutputStream output = new FileOutputStream(file);){
            properties.store(output, null);
        }
    }

    public void load() throws IOException {
        File file = PATH.toFile();
        if (!file.exists()) {
            this.save();
        }
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(file);){
            properties.load(input);
        }
        try {
            this.skipDownload = Boolean.parseBoolean(properties.getProperty("skip-download"));
            this.downloadMirror = properties.getProperty("download-mirror");
            this.userAgent = properties.getProperty("user-agent");
            this.useCache = Boolean.parseBoolean(properties.getProperty("use-cache"));
        }
        catch (Exception e) {
            if (deleteRetries++ > 20) {
                return;
            }
            file.delete();
            this.save();
        }
    }
}

