/*
 * Decompiled with CFR 0.152.
 */
package net.northwesttrees.cctvcraft.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.northwesttrees.cctvcraft.CctvcraftMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CctvcraftModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.cameraPosX = message.data.cameraPosX;
                    variables.cameraPosY = message.data.cameraPosY;
                    variables.cameraPosZ = message.data.cameraPosZ;
                    variables.isPlayerInCameraView = message.data.isPlayerInCameraView;
                    variables.monitorPosX = message.data.monitorPosX;
                    variables.monitorPosY = message.data.monitorPosY;
                    variables.monitorPosZ = message.data.monitorPosZ;
                    variables.savedPlayerGamemode = message.data.savedPlayerGamemode;
                    variables.savedPlayerPosX = message.data.savedPlayerPosX;
                    variables.savedPlayerPosY = message.data.savedPlayerPosY;
                    variables.savedPlayerPosZ = message.data.savedPlayerPosZ;
                    variables.savedPlayerRotPitch = message.data.savedPlayerRotPitch;
                    variables.savedPlayerRotYaw = message.data.savedPlayerRotYaw;
                    variables.cameraNumber = message.data.cameraNumber;
                    variables.members = message.data.members;
                    variables.memberNames = message.data.memberNames;
                    variables.cameraWorld = message.data.cameraWorld;
                    variables.savedWorld = message.data.savedWorld;
                    variables.blockPosX = message.data.blockPosX;
                    variables.blockPosY = message.data.blockPosY;
                    variables.blockPosZ = message.data.blockPosZ;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double cameraPosX = 0.0;
        public double cameraPosY = 0.0;
        public double cameraPosZ = 0.0;
        public boolean isPlayerInCameraView = false;
        public double monitorPosX = 0.0;
        public double monitorPosY = 0.0;
        public double monitorPosZ = 0.0;
        public String savedPlayerGamemode = "Survival";
        public double savedPlayerPosX = 0.0;
        public double savedPlayerPosY = 0.0;
        public double savedPlayerPosZ = 0.0;
        public double savedPlayerRotPitch = 0.0;
        public double savedPlayerRotYaw = 0.0;
        public double cameraNumber = 0.0;
        public String members = "";
        public String memberNames = "";
        public String cameraWorld = "minecraft:overworld";
        public String savedWorld = "minecraft:overworld";
        public double blockPosX = 0.0;
        public double blockPosY = 0.0;
        public double blockPosZ = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("cameraPosX", this.cameraPosX);
            nbt.m_128347_("cameraPosY", this.cameraPosY);
            nbt.m_128347_("cameraPosZ", this.cameraPosZ);
            nbt.m_128379_("isPlayerInCameraView", this.isPlayerInCameraView);
            nbt.m_128347_("monitorPosX", this.monitorPosX);
            nbt.m_128347_("monitorPosY", this.monitorPosY);
            nbt.m_128347_("monitorPosZ", this.monitorPosZ);
            nbt.m_128359_("savedPlayerGamemode", this.savedPlayerGamemode);
            nbt.m_128347_("savedPlayerPosX", this.savedPlayerPosX);
            nbt.m_128347_("savedPlayerPosY", this.savedPlayerPosY);
            nbt.m_128347_("savedPlayerPosZ", this.savedPlayerPosZ);
            nbt.m_128347_("savedPlayerRotPitch", this.savedPlayerRotPitch);
            nbt.m_128347_("savedPlayerRotYaw", this.savedPlayerRotYaw);
            nbt.m_128347_("cameraNumber", this.cameraNumber);
            nbt.m_128359_("members", this.members);
            nbt.m_128359_("memberNames", this.memberNames);
            nbt.m_128359_("cameraWorld", this.cameraWorld);
            nbt.m_128359_("savedWorld", this.savedWorld);
            nbt.m_128347_("blockPosX", this.blockPosX);
            nbt.m_128347_("blockPosY", this.blockPosY);
            nbt.m_128347_("blockPosZ", this.blockPosZ);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.cameraPosX = nbt.m_128459_("cameraPosX");
            this.cameraPosY = nbt.m_128459_("cameraPosY");
            this.cameraPosZ = nbt.m_128459_("cameraPosZ");
            this.isPlayerInCameraView = nbt.m_128471_("isPlayerInCameraView");
            this.monitorPosX = nbt.m_128459_("monitorPosX");
            this.monitorPosY = nbt.m_128459_("monitorPosY");
            this.monitorPosZ = nbt.m_128459_("monitorPosZ");
            this.savedPlayerGamemode = nbt.m_128461_("savedPlayerGamemode");
            this.savedPlayerPosX = nbt.m_128459_("savedPlayerPosX");
            this.savedPlayerPosY = nbt.m_128459_("savedPlayerPosY");
            this.savedPlayerPosZ = nbt.m_128459_("savedPlayerPosZ");
            this.savedPlayerRotPitch = nbt.m_128459_("savedPlayerRotPitch");
            this.savedPlayerRotYaw = nbt.m_128459_("savedPlayerRotYaw");
            this.cameraNumber = nbt.m_128459_("cameraNumber");
            this.members = nbt.m_128461_("members");
            this.memberNames = nbt.m_128461_("memberNames");
            this.cameraWorld = nbt.m_128461_("cameraWorld");
            this.savedWorld = nbt.m_128461_("savedWorld");
            this.blockPosX = nbt.m_128459_("blockPosX");
            this.blockPosY = nbt.m_128459_("blockPosY");
            this.blockPosZ = nbt.m_128459_("blockPosZ");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cctvcraft", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.cameraPosX = original.cameraPosX;
            clone.cameraPosY = original.cameraPosY;
            clone.cameraPosZ = original.cameraPosZ;
            clone.isPlayerInCameraView = original.isPlayerInCameraView;
            clone.monitorPosX = original.monitorPosX;
            clone.monitorPosY = original.monitorPosY;
            clone.monitorPosZ = original.monitorPosZ;
            clone.savedPlayerGamemode = original.savedPlayerGamemode;
            clone.savedPlayerPosX = original.savedPlayerPosX;
            clone.savedPlayerPosY = original.savedPlayerPosY;
            clone.savedPlayerPosZ = original.savedPlayerPosZ;
            clone.savedPlayerRotPitch = original.savedPlayerRotPitch;
            clone.savedPlayerRotYaw = original.savedPlayerRotYaw;
            clone.cameraNumber = original.cameraNumber;
            clone.members = original.members;
            clone.memberNames = original.memberNames;
            clone.cameraWorld = original.cameraWorld;
            clone.savedWorld = original.savedWorld;
            clone.blockPosX = original.blockPosX;
            clone.blockPosY = original.blockPosY;
            clone.blockPosZ = original.blockPosZ;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

