/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbattery;

import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.config.CServer;
import com.hlysine.create_connected.content.ISplitShaftBlockEntity;
import com.hlysine.create_connected.content.kineticbattery.KineticBatteryBlock;
import com.hlysine.create_connected.content.kineticbattery.KineticBatteryValueBox;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Math;

public class KineticBatteryBlockEntity
extends GeneratingKineticBlockEntity
implements ISplitShaftBlockEntity,
ThresholdSwitchObservable {
    private static final int SYNC_RATE = 20;
    public static final double CHARGE_THRESHOlD = 72000.0;
    private double batteryLevel;
    private int syncCooldown;
    protected boolean queuedSync;
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;

    public KineticBatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)ConnectedLang.translateDirect("battery.rotation_direction", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new KineticBatteryValueBox(3.0));
        this.movementDirection.withCallback(i -> {
            this.updateGeneratedRotation();
            this.sendDataImmediately();
        });
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        AdvancementBehaviour.registerAwardables((SmartBlockEntity)this, behaviours, CCAdvancements.KINETIC_BATTERY);
    }

    public void initialize() {
        super.initialize();
        this.updateGeneratedRotation();
    }

    public static double getMaxBatteryLevel() {
        return CServer.BatteryCapacity.get() * 3600.0 * 20.0;
    }

    public static int getDischargeRPM() {
        return CServer.BatteryDischargeRPM.get();
    }

    public int getCrudeBatteryLevel(int totalLevels) {
        if (this.batteryLevel >= KineticBatteryBlockEntity.getMaxBatteryLevel()) {
            return totalLevels;
        }
        if (this.batteryLevel <= 0.0) {
            return 0;
        }
        return (int)Math.floor((double)(this.batteryLevel / KineticBatteryBlockEntity.getMaxBatteryLevel() * (double)(totalLevels - 1))) + 1;
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.getSpeed() == 0.0f || !this.hasNetwork()) {
            return;
        }
        boolean changed = false;
        if (KineticBatteryBlock.isDischarging(this.m_58900_())) {
            if (this.batteryLevel > 0.0 && this.stress > 0.0f) {
                if (this.lastCapacityProvided == 0.0f) {
                    this.calculateAddedStressCapacity();
                }
                this.batteryLevel = Math.max((double)(this.batteryLevel - (double)(this.lastCapacityProvided * Math.abs((float)this.getGeneratedSpeed()))), (double)0.0);
                changed = true;
            }
        } else if (this.batteryLevel < KineticBatteryBlockEntity.getMaxBatteryLevel() && this.capacity > 0.0f) {
            if (this.lastStressApplied == 0.0f) {
                this.calculateStressApplied();
            }
            this.batteryLevel = Math.min((double)(this.batteryLevel + (double)(this.lastStressApplied * Math.abs((float)this.getTheoreticalSpeed()))), (double)KineticBatteryBlockEntity.getMaxBatteryLevel());
            changed = true;
        }
        if (changed) {
            this.updateLevel();
        }
    }

    private void updateLevel() {
        int crudeLevel = this.getCrudeBatteryLevel(5);
        int oldLevel = (Integer)this.m_58900_().m_61143_((Property)KineticBatteryBlock.LEVEL);
        if (oldLevel != crudeLevel) {
            if (crudeLevel == 5) {
                AdvancementBehaviour.tryAward((BlockEntity)this, CCAdvancements.KINETIC_BATTERY);
            }
            KineticBatteryBlockEntity.switchToBlockState((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (BlockState)((BlockState)this.m_58900_().m_61124_((Property)KineticBatteryBlock.LEVEL, (Comparable)Integer.valueOf(crudeLevel))));
        }
        this.sendData();
    }

    public double getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(double batteryLevel) {
        this.batteryLevel = batteryLevel;
        this.updateLevel();
        this.sendDataImmediately();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 20;
    }

    public float getGeneratedSpeed() {
        if (!KineticBatteryBlock.isDischarging(this.m_58900_()) || KineticBatteryBlock.isCurrentStageComplete(this.m_58900_())) {
            return 0.0f;
        }
        return KineticBatteryBlockEntity.convertToDirection((float)KineticBatteryBlockEntity.getDischargeRPM(), (Direction)((Direction)this.m_58900_().m_61143_((Property)KineticBatteryBlock.FACING))) * (float)(this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? -1 : 1);
    }

    public float calculateAddedStressCapacity() {
        if (!KineticBatteryBlock.isDischarging(this.m_58900_()) || KineticBatteryBlock.isCurrentStageComplete(this.m_58900_())) {
            return 0.0f;
        }
        return super.calculateAddedStressCapacity();
    }

    public float calculateStressApplied() {
        if (!KineticBatteryBlock.isDischarging(this.m_58900_()) && !KineticBatteryBlock.isCurrentStageComplete(this.m_58900_())) {
            return super.calculateStressApplied();
        }
        this.lastStressApplied = 0.0f;
        return 0.0f;
    }

    @Override
    public float getRotationSpeedModifier(Direction face) {
        if (face.m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)KineticBatteryBlock.FACING)).m_122434_()) {
            return 0.0f;
        }
        if (face != this.m_58900_().m_61143_((Property)KineticBatteryBlock.FACING) && !KineticBatteryBlock.isCurrentStageComplete(this.m_58900_())) {
            return 0.0f;
        }
        return 1.0f;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.batteryLevel = compound.m_128457_("batteryLevel");
        this.queuedSync = compound.m_128471_("queuedSync");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128347_("batteryLevel", this.batteryLevel);
        compound.m_128379_("queuedSync", this.queuedSync);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ConnectedLang.translate("battery.status", this.getBatteryStatusTextComponent().m_130940_(ChatFormatting.GREEN)).forGoggles(tooltip);
        ConnectedLang.builder().add(ConnectedLang.translateDirect("battery.charge", new Object[0]).m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)this.barComponent(0, this.getCrudeBatteryLevel(20), 20))).forGoggles(tooltip);
        ConnectedLang.number(this.batteryLevel / 3600.0 / 20.0).style(ChatFormatting.BLUE).add(ConnectedLang.text(" / ").style(ChatFormatting.GRAY)).add(ConnectedLang.number(KineticBatteryBlockEntity.getMaxBatteryLevel() / 3600.0 / 20.0).add(Component.m_237113_((String)" ")).add(ConnectedLang.translate("generic.unit.su_hours", new Object[0])).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public MutableComponent getBatteryStatusTextComponent() {
        boolean complete = KineticBatteryBlock.isCurrentStageComplete(this.m_58900_());
        boolean discharging = KineticBatteryBlock.isDischarging(this.m_58900_());
        if (discharging && !complete) {
            return ConnectedLang.translateDirect("battery.status.discharging", new Object[0]);
        }
        if (!discharging && !complete) {
            return ConnectedLang.translateDirect("battery.status.charging", new Object[0]);
        }
        if (!discharging && complete) {
            return ConnectedLang.translateDirect("battery.status.full", new Object[0]);
        }
        return ConnectedLang.translateDirect("battery.status.empty", new Object[0]);
    }

    private MutableComponent barComponent(int minValue, int level, int maxValue) {
        return Component.m_237119_().m_7220_((Component)this.bars(java.lang.Math.max(0, minValue - 1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(minValue > 0 ? 1 : 0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(java.lang.Math.max(0, level - minValue), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(java.lang.Math.max(0, maxValue - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(java.lang.Math.max(0, java.lang.Math.min(18 - maxValue, (maxValue / 5 + 1) * 5 - maxValue)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.m_237113_((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    public int getMaxValue() {
        return (int)(KineticBatteryBlockEntity.getMaxBatteryLevel() / 3600.0 / 20.0);
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        return (int)(this.batteryLevel / 3600.0 / 20.0);
    }

    public MutableComponent format(int value) {
        return ConnectedLang.number(value).add(Component.m_237113_((String)" ")).add(ConnectedLang.translate("generic.unit.su_hours", new Object[0])).component();
    }
}

