/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.tom.createores.Registration;
import com.tom.createores.jei.ItemIcon;
import com.tom.createores.jei.JEIHandler;
import com.tom.createores.jei.VeinIngredient;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.BiomeTooltip;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VeinCategory
implements IRecipeCategory<VeinRecipe> {
    protected IDrawable background;
    protected IDrawable icon = new ItemIcon(() -> new ItemStack((ItemLike)Registration.NORMAL_DRILL_ITEM.get()));
    protected IDrawable biomeWIcon;
    protected IDrawable biomeBIcon;

    public VeinCategory() {
        this.background = new EmptyBackground(177, 100);
        this.biomeWIcon = new ItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_));
        this.biomeBIcon = new DoubleItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_), () -> new ItemStack((ItemLike)Items.f_42127_));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VeinRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 25).addIngredient(VeinIngredient.VEIN, (Object)recipe);
    }

    public void draw(VeinRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.biomeWIcon.draw(stack, 100, 5);
        this.biomeBIcon.draw(stack, 100, 25);
    }

    public List<Component> getTooltipStrings(VeinRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX > 100.0 && mouseX < 118.0) {
            if (mouseY > 5.0 && mouseY < 23.0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.biome.whitelist"));
                BiomeTooltip.listBiomes(recipe.biomeWhitelist, tooltip);
            } else if (mouseY > 25.0 && mouseY < 43.0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.biome.blacklist"));
                BiomeTooltip.listBiomes(recipe.biomeBlacklist, tooltip);
            } else {
                BiomeTooltip.resetPage();
            }
        }
        return tooltip;
    }

    public RecipeType<VeinRecipe> getRecipeType() {
        return JEIHandler.VEINS;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.coe.recipe.veins");
    }
}

