/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.util;

import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class GuiUtils {
    private GuiUtils() {
    }

    public static void renderText(GuiGraphics guiGraphics, int x, int y, float scale, String text, int color) {
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_((float)x, (float)y, 0.0f);
        stack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, text, 0, 0, color);
        stack.m_85849_();
    }

    public static final class TooltipBuilder {
        private final List<Component> value = new ArrayList<Component>();

        private TooltipBuilder() {
        }

        public static TooltipBuilder builder() {
            return new TooltipBuilder();
        }

        public Component resolve() {
            MutableComponent component = Component.m_237119_();
            for (Component e : this.value) {
                component = component.m_7220_(e).m_130946_("\n");
            }
            return component;
        }

        public List<Component> resolveList() {
            return this.value;
        }

        public TooltipBuilder addBlankLine() {
            return this.addComponent((Component)Component.m_237113_((String)" "));
        }

        public TooltipBuilder addComponent(Component component) {
            this.value.add(component);
            return this;
        }

        public TooltipBuilder addHeader(String key) {
            return this.addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GOLD));
        }

        public TooltipBuilder addDescription(String key) {
            return this.addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.WHITE));
        }

        public TooltipBuilder addCustomAction(String input, String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(InputConstants.m_84851_((String)input).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public TooltipBuilder addClickAction(String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click", ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public TooltipBuilder addHoldAction(String input, String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_hold", ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)TextUtils.colorize(InputConstants.m_84851_((String)input).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public TooltipBuilder addShiftClickAction(String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(String.format("%s + %s", InputConstants.m_84851_((String)"key.keyboard.left.shift").m_84875_().getString(), TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click")), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }
    }
}

